/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.function.Predicate;
import mods.cybercat.gigeresque.bvanseg.Cooldown;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DelayedAttackGoal
extends MeleeAttackGoal {
    protected static final Predicate<BlockState> NEST = state -> state.is(GigBlocks.NEST_RESIN_WEB_CROSS.get());
    protected final AlienEntity alienEntity;
    protected final Cooldown attackAnimationCooldown;
    protected boolean ranAttackAnimation;

    public DelayedAttackGoal(AlienEntity alienEntity, double speedModifier, int delayTicksBeforeAttack) {
        super((PathfinderMob)alienEntity, speedModifier, true);
        this.alienEntity = alienEntity;
        this.attackAnimationCooldown = Cooldown.withCooldownTimeInTicks("attackAnimationCooldownInTicks", delayTicksBeforeAttack);
    }

    public void stop() {
        LivingEntity livingentity = this.alienEntity.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.alienEntity.setTarget(null);
        }
        this.alienEntity.setAggressive(false);
    }

    public void tick() {
        super.tick();
        this.attackAnimationCooldown.tick();
        if (this.alienEntity.getTarget() != null && this.ranAttackAnimation && !this.attackAnimationCooldown.isActive() && this.alienEntity.isWithinMeleeAttackRange(this.alienEntity.getTarget()) && this.alienEntity.getSensing().hasLineOfSight((Entity)this.alienEntity.getTarget())) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.mob.doHurtTarget((Entity)this.alienEntity.getTarget());
            this.ranAttackAnimation = false;
        }
    }

    public boolean canUse() {
        return this.isAbleToAttack() && super.canUse();
    }

    public boolean canContinueToUse() {
        return this.isAbleToAttack() && super.canContinueToUse();
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity target) {
        if (!this.ranAttackAnimation && this.canPerformAttack(target)) {
            this.alienEntity.animationSelector.select(this.alienEntity);
            this.ranAttackAnimation = true;
            this.attackAnimationCooldown.reset();
        }
    }

    protected boolean isAbleToAttack() {
        if (this.alienEntity.isVehicle() || this.alienEntity.getTarget() == null) {
            return false;
        }
        if (this.alienEntity.hasEffect(MobEffects.CONFUSION)) {
            return false;
        }
        return !NEST.test(this.alienEntity.getTarget().getInBlockState());
    }
}

