/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.blood;

import mods.cybercat.gigeresque.client.particle.GigParticles;
import mods.cybercat.gigeresque.common.entity.impl.blood.AcidEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MobBloodEntity
extends Entity {
    public MobBloodEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.setDeltaMovement(Vec3.ZERO);
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void tick() {
        super.tick();
        if (this.tickCount == 1) {
            this.moveTo(this.blockPosition().offset(0, 0, 0), this.getYRot(), this.getXRot());
        }
        this.applyCustomGravity();
        if (this.level().isClientSide()) {
            this.applyParticle();
        }
        if (!this.level().isClientSide()) {
            if (this.tickCount >= 10) {
                this.kill();
            }
            if (this.level().getBlockState(this.blockPosition()).is(Blocks.LAVA)) {
                this.remove(Entity.RemovalReason.KILLED);
            }
            this.level().getEntities((Entity)this, this.getBoundingBox()).forEach(e -> {
                if (e instanceof AcidEntity && e.tickCount < this.tickCount) {
                    e.remove(Entity.RemovalReason.KILLED);
                }
            });
        }
    }

    private void applyParticle() {
        for (int i = 0; i < this.random.nextIntBetweenInclusive(0, 4); ++i) {
            this.level().addAlwaysVisibleParticle((ParticleOptions)GigParticles.BLOOD.get(), (double)this.blockPosition().getX() + this.random.nextDouble(), (double)this.blockPosition().getY() + 0.09, (double)this.blockPosition().getZ() + this.random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    private void applyCustomGravity() {
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.38));
    }

    public void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    public boolean dampensVibrations() {
        return true;
    }
}

