/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.misc;

import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HologramEntity
extends Entity {
    public static final EntityDataAccessor<Integer> DISTANCE_STATE = SynchedEntityData.defineId(HologramEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DISTANCE_FROM_STRUCTURE = SynchedEntityData.defineId(HologramEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public AnimationDispatcher animationDispatcher = new AnimationDispatcher(this);

    public HologramEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public int getDistanceState() {
        return (Integer)this.entityData.get(DISTANCE_STATE);
    }

    public void setDistanceState(int distanceState) {
        this.entityData.set(DISTANCE_STATE, (Object)distanceState);
    }

    public int getDistanceFromStructure() {
        return (Integer)this.entityData.get(DISTANCE_FROM_STRUCTURE);
    }

    public void setDistanceFromStructure(int distanceState) {
        this.entityData.set(DISTANCE_FROM_STRUCTURE, (Object)distanceState);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        builder.define(DISTANCE_STATE, (Object)0);
        builder.define(DISTANCE_FROM_STRUCTURE, (Object)0);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        this.setDistanceState(compound.getInt("distance_state"));
        this.setDistanceFromStructure(compound.getInt("distance_from_structure"));
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        compound.putInt("distance_state", this.getDistanceState());
        compound.putInt("distance_from_structure", this.getDistanceFromStructure());
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public boolean dampensVibrations() {
        return true;
    }

    public boolean ignoreExplosion(@NotNull Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void tick() {
        if (this.tickCount == 1) {
            this.moveTo(this.blockPosition().offset(0, 0, 0), this.getYRot(), this.getXRot());
        }
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        super.tick();
        if (!this.level().isClientSide() && this.tickCount >= 125) {
            this.kill();
        }
    }
}

