/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBreakProgressManager {
    private static final Map<BlockPos, Map.Entry<Long, Float>> BLOCK_BREAK_PROGRESS_MAP = new HashMap<BlockPos, Map.Entry<Long, Float>>();

    public static void tick(Level level) {
        long gameTime = level.getGameTime();
        if (gameTime % 400L != 0L) {
            return;
        }
        BLOCK_BREAK_PROGRESS_MAP.entrySet().removeIf(entry -> {
            Long lastUpdateTimeMillis = (Long)((Map.Entry)entry.getValue()).getKey();
            return System.currentTimeMillis() > lastUpdateTimeMillis;
        });
    }

    public static void damage(Level level, BlockPos blockPos, float damage) {
        BlockPos immutableBlockPos = blockPos.immutable();
        BLOCK_BREAK_PROGRESS_MAP.compute(immutableBlockPos, (key, entry) -> {
            BlockState blockState = level.getBlockState(immutableBlockPos);
            Block block = blockState.getBlock();
            float currentDestroyProgress = entry == null ? 0.0f : ((Float)entry.getValue()).floatValue();
            float defaultDestroyTimeInSeconds = block.defaultDestroyTime();
            if (defaultDestroyTimeInSeconds < 0.0f) {
                return null;
            }
            float destroyTimeInTicks = block.defaultDestroyTime() * 20.0f;
            float weight = Math.max(destroyTimeInTicks, 1.0f);
            float newDestroyProgress = currentDestroyProgress + damage / weight;
            int progress = (int)Mth.clamp((float)newDestroyProgress, (float)0.0f, (float)9.0f);
            int hash = Objects.hash(immutableBlockPos);
            if (progress >= 9) {
                level.destroyBlockProgress(hash, immutableBlockPos, -1);
                level.destroyBlock(immutableBlockPos, false);
                return null;
            }
            level.destroyBlockProgress(hash, immutableBlockPos, progress);
            return Map.entry(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L), Float.valueOf(newDestroyProgress));
        });
    }

    private BlockBreakProgressManager() {
        throw new UnsupportedOperationException();
    }
}

