/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.mixins.common.entity;

import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.helper.GigCommonMethods;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.fluid.GigFluids;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.status.effect.impl.DNAStatusEffect;
import mods.cybercat.gigeresque.common.status.effect.impl.EggMorphingStatusEffect;
import mods.cybercat.gigeresque.common.status.effect.impl.ImpregnationStatusEffect;
import mods.cybercat.gigeresque.common.status.effect.impl.SporeStatusEffect;
import mods.cybercat.gigeresque.common.status.effect.impl.TraumaStatusEffect;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    protected LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Shadow
    abstract boolean hasEffect(Holder<MobEffect> var1);

    @Shadow
    abstract boolean addEffect(MobEffectInstance var1);

    @Shadow
    public abstract boolean hurt(@NotNull DamageSource var1, float var2);

    @Shadow
    public abstract boolean isDeadOrDying();

    @Shadow
    public abstract float getMaxHealth();

    @Shadow
    public abstract boolean isAlive();

    @Shadow
    public abstract float getHealth();

    @Shadow
    public abstract boolean removeEffect(Holder<MobEffect> var1);

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void gigeresque$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.getVehicle() != null && this.getVehicle().getType().is(GigTags.GIG_ALIENS) && (source == this.damageSources().drown() || source == this.damageSources().inWall())) {
            callbackInfo.setReturnValue((Object)false);
        }
        if (amount >= 2.0f && this.getFirstPassenger() != null) {
            if (this.getPassengers().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
                FacehuggerEntity facehugger = (FacehuggerEntity)this.getFirstPassenger();
                facehugger.hurt(source, amount / 2.0f);
                facehugger.addEffect(new MobEffectInstance(MobEffects.CONFUSION, CommonMod.config.facehuggerConfigs.facehuggerStunTickTimer, 60, false, false));
                facehugger.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 10, false, false));
                facehugger.animationDispatcher.sendStunned();
                facehugger.detachFromHost();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void gigeresque$tick(CallbackInfo callbackInfo) {
        if (!this.level().isClientSide) {
            Fluid getType;
            if (this.getPassengers().stream().anyMatch(AlienEntity.class::isInstance)) {
                this.setAirSupply(this.getMaxAirSupply());
            }
            if (Constants.hasCureEffects.test(this)) {
                this.removeEffect(GigStatusEffects.DNA);
                Object t = Constants.self((Object)this);
                if (t instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)t;
                    AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(Constants.modResource("dna_cure"));
                    if (advancement != null) {
                        serverPlayer.getAdvancements().award(advancement, "criteria_key");
                    }
                }
            }
            if (Constants.hasEggEffect.test(this) && !GigEntityUtils.inResinEnoughToBeEggmorphed(this)) {
                this.removeEffect(GigStatusEffects.EGGMORPHING);
            }
            if (Constants.isCreativeSpecPlayer.test(this)) {
                if (Constants.hasEggEffect.test(this)) {
                    this.removeEffect(GigStatusEffects.EGGMORPHING);
                }
                if (Constants.hasImpEffect.test(this)) {
                    this.removeEffect(GigStatusEffects.IMPREGNATION);
                }
                if (Constants.hasDNAEffect.test(this)) {
                    this.removeEffect(GigStatusEffects.DNA);
                }
                if (Constants.hasSporeEffect.test(this)) {
                    this.removeEffect(GigStatusEffects.SPORE);
                }
            }
            if (Constants.shouldApplyImpEffects.test(this)) {
                GigCommonMethods.generateBloodPool((LivingEntity)Constants.self((Object)this), this.blockPosition().above(), 0, 0);
                this.hurt(GigDamageSources.of(this.level(), GigDamageSources.CHESTBURSTING), 0.2f);
            }
            if ((getType = this.level().getFluidState(this.blockPosition()).getType()) == GigFluids.BLACK_FLUID_STILL.get() || getType == GigFluids.BLACK_FLUID_FLOWING.get()) {
                this.gigeresque$handleBlackGooLogic(this);
            }
        }
    }

    @Unique
    private void gigeresque$handleBlackGooLogic(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (this.hasEffect(GigStatusEffects.DNA) || GigEntityUtils.isTargetDNAImmune((Entity)livingEntity)) {
            return;
        }
        if (Constants.notPlayer.test((Entity)livingEntity) && !Constants.isCreeper.test(this)) {
            this.addEffect(new MobEffectInstance(GigStatusEffects.DNA, CommonMod.config.getgooEffectTickTimer(), 0));
        }
        if (Constants.isCreeper.test(this) && Constants.notPlayer.test((Entity)livingEntity)) {
            this.addEffect(new MobEffectInstance(GigStatusEffects.DNA, 60000, 0));
        }
        if (Constants.isNotCreativeSpecPlayer.test((Entity)livingEntity)) {
            this.addEffect(new MobEffectInstance(GigStatusEffects.DNA, CommonMod.config.getgooEffectTickTimer(), 0));
        }
    }

    @Inject(method={"isImmobile"}, at={@At(value="RETURN")}, cancellable=true)
    protected void gigeresque$isImmobile(CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.getPassengers().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
            callbackInfo.setReturnValue((Object)true);
        }
    }

    @Inject(method={"removeAllEffects"}, at={@At(value="HEAD")}, cancellable=true)
    public void noMilkRemoval(CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.hasEffect(GigStatusEffects.EGGMORPHING) || this.hasEffect(GigStatusEffects.ACID) || this.hasEffect(GigStatusEffects.DNA) || this.hasEffect(GigStatusEffects.SPORE) || this.hasEffect(GigStatusEffects.IMPREGNATION)) {
            callbackInfo.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V"}, at={@At(value="TAIL")})
    private void runAtEffectRemoval(MobEffectInstance mobEffectInstance, CallbackInfo ci) {
        if (!this.level().isClientSide) {
            DNAStatusEffect.effectRemoval((LivingEntity)Constants.self((Object)this), mobEffectInstance);
            SporeStatusEffect.effectRemoval((LivingEntity)Constants.self((Object)this), mobEffectInstance);
            ImpregnationStatusEffect.effectRemoval((LivingEntity)Constants.self((Object)this), mobEffectInstance);
            EggMorphingStatusEffect.effectRemoval((LivingEntity)Constants.self((Object)this), mobEffectInstance);
            TraumaStatusEffect.effectRemoval((LivingEntity)Constants.self((Object)this), mobEffectInstance);
        }
    }
}

