/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.bvanseg;

import java.time.Duration;
import mods.cybercat.gigeresque.bvanseg.NBTSerializable;
import mods.cybercat.gigeresque.bvanseg.TickUtil;
import net.minecraft.class_2487;

public class Cooldown
implements NBTSerializable {
    private final long maxCooldownInTicks;
    private final String name;
    private long cooldownInTicks;

    public static Cooldown withCooldownTime(String name, Duration cooldownTime) {
        return Cooldown.withCooldownTimeInTicks(name, TickUtil.toTicks(cooldownTime));
    }

    public static Cooldown withCooldownTimeInTicks(String name, long maxCooldownInTicks) {
        return new Cooldown(name, maxCooldownInTicks);
    }

    private Cooldown(String name, long maxCooldownInTicks) {
        this.maxCooldownInTicks = maxCooldownInTicks;
        this.name = name;
    }

    public void tick() {
        this.cooldownInTicks = Math.max(this.cooldownInTicks - 1L, 0L);
    }

    public boolean isActive() {
        return this.cooldownInTicks > 0L;
    }

    public void reset() {
        this.cooldownInTicks = this.maxCooldownInTicks;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void load(class_2487 compoundTag) {
        compoundTag.method_10544(this.name, this.cooldownInTicks);
    }

    @Override
    public void save(class_2487 compoundTag) {
        if (compoundTag.method_10545(this.name)) {
            this.cooldownInTicks = compoundTag.method_10537(this.name);
        }
    }
}

