/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.util.nest;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.block.NestResinBlock;
import mods.cybercat.gigeresque.common.block.NestResinWebBlock;
import mods.cybercat.gigeresque.common.block.NestResinWebVariant;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.nest.NestBlockData;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public record NestBuildingHelper() {
    public static void tryBuildNestAround(class_1937 level, class_2338 pos, AlienEntity alienEntity) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 3; ++y) {
                    class_2338 blockPos = pos.method_10069(x, y, z);
                    NestBlockData nestBlockData = NestBuildingHelper.getNestBlockData(level, blockPos);
                    if (nestBlockData == null || level.method_8317(pos) >= 6) continue;
                    class_2680 resinBlock = (class_2680)GigBlocks.NEST_RESIN.get().method_9564().method_11657((class_2769)NestResinBlock.LAYERS, (Comparable)Integer.valueOf(Math.min(8, level.method_8409().method_43051(1, 7) + 1)));
                    class_2680 webBlock = GigBlocks.NEST_RESIN_WEB_CROSS.get().method_9564();
                    class_2680 nestResinWebState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)GigBlocks.NEST_RESIN_WEB.get().method_9564().method_11657((class_2769)NestResinWebBlock.UP, (Comparable)Boolean.valueOf(nestBlockData.hasUpCoverage()))).method_11657((class_2769)NestResinWebBlock.NORTH, (Comparable)Boolean.valueOf(nestBlockData.hasNorthCoverage()))).method_11657((class_2769)NestResinWebBlock.SOUTH, (Comparable)Boolean.valueOf(nestBlockData.hasSouthCoverage()))).method_11657((class_2769)NestResinWebBlock.EAST, (Comparable)Boolean.valueOf(nestBlockData.hasEastCoverage()))).method_11657((class_2769)NestResinWebBlock.WEST, (Comparable)Boolean.valueOf(nestBlockData.hasWestCoverage()))).method_11657(NestResinWebBlock.VARIANTS, (Comparable)((Object)NestResinWebVariant.values()[level.method_8409().method_43048(NestResinWebVariant.values().length)]));
                    if (nestBlockData.isFloor() && !level.method_8320(blockPos).method_26164(GigTags.DUNGEON_BLOCKS)) {
                        level.method_8501(blockPos, level.method_8409().method_43051(0, 50) > 30 ? webBlock : resinBlock);
                        if (!alienEntity.hasHomeBlock()) {
                            alienEntity.setHomeBlock(blockPos);
                        }
                        alienEntity.savedNestWebCross = blockPos;
                    }
                    if (nestBlockData.isCorner() && !level.method_8320(blockPos).method_26164(GigTags.DUNGEON_BLOCKS)) {
                        level.method_8501(blockPos, webBlock);
                        alienEntity.savedNestWebCross = blockPos;
                    }
                    if (!nestBlockData.isWall() && !nestBlockData.isCeiling() || level.method_8320(blockPos).method_26164(GigTags.DUNGEON_BLOCKS)) continue;
                    level.method_8501(blockPos, nestResinWebState);
                    alienEntity.savedNestWebCross = blockPos;
                }
            }
        }
    }

    public static boolean isResinBlock(class_2248 block) {
        return block.method_9564().method_26164(GigTags.NEST_BLOCKS);
    }

    private static NestBlockData getNestBlockData(class_1937 world, class_2338 blockPos) {
        class_2680 actualState = world.method_8320(blockPos);
        class_2248 actualBlock = actualState.method_26204();
        if (NestBuildingHelper.isResinBlock(actualBlock)) {
            return null;
        }
        class_2338 upPos = blockPos.method_10084();
        class_2680 upState = world.method_8320(upPos);
        class_2338 downPos = blockPos.method_10074();
        class_2680 downState = world.method_8320(downPos);
        class_2338 northPos = blockPos.method_10095();
        class_2680 northState = world.method_8320(northPos);
        class_2338 southPos = blockPos.method_10072();
        class_2680 southState = world.method_8320(southPos);
        class_2338 eastPos = blockPos.method_10078();
        class_2680 eastState = world.method_8320(eastPos);
        class_2338 westPos = blockPos.method_10067();
        class_2680 westState = world.method_8320(westPos);
        List<Pair> blockStates = List.of(Pair.of((Object)upPos, (Object)upState), Pair.of((Object)downPos, (Object)downState), Pair.of((Object)northPos, (Object)northState), Pair.of((Object)southPos, (Object)southState), Pair.of((Object)eastPos, (Object)eastState), Pair.of((Object)westPos, (Object)westState));
        AtomicInteger fullCoverage = new AtomicInteger();
        AtomicInteger horizontalCoverage = new AtomicInteger();
        AtomicInteger cornerCoverage = new AtomicInteger();
        blockStates.forEach(it -> {
            boolean isOpaqueCube = ((class_2680)it.getSecond()).method_26216((class_1922)world, (class_2338)it.getFirst());
            if (isOpaqueCube) {
                if (!NestBuildingHelper.isResinBlock(((class_2680)it.getSecond()).method_26204())) {
                    if (it.getFirst() != upPos && it.getFirst() != downPos) {
                        horizontalCoverage.getAndIncrement();
                    }
                    fullCoverage.getAndIncrement();
                } else {
                    cornerCoverage.getAndIncrement();
                }
            }
        });
        boolean isFloor = actualState.method_26215() && upState.method_26215() && !NestBuildingHelper.isResinBlock(downState.method_26204()) && downState.method_26216((class_1922)world, downPos) && world.method_8317(blockPos) < 10;
        boolean isWall = !isFloor && actualState.method_26215() && (upState.method_26215() || NestBuildingHelper.isResinBlock(upState.method_26204())) && 1 <= horizontalCoverage.get() && horizontalCoverage.get() <= 2 && world.method_8317(blockPos) < 10;
        boolean isCorner = actualState.method_26215() && 3 <= fullCoverage.get() && fullCoverage.get() <= 5 && world.method_8317(blockPos) < 10;
        boolean isCeiling = actualState.method_26215() && (downState.method_26215() || NestBuildingHelper.isResinBlock(downState.method_26204())) && upState.method_26216((class_1922)world, downPos) && !isCorner && world.method_8317(blockPos) < 10;
        return new NestBlockData(fullCoverage.get(), isCorner, isFloor, isCeiling, isWall, upState.method_26216((class_1922)world, upPos), downState.method_26216((class_1922)world, downPos), northState.method_26216((class_1922)world, northPos), southState.method_26216((class_1922)world, southPos), eastState.method_26216((class_1922)world, eastPos), westState.method_26216((class_1922)world, westPos));
    }
}

