/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.feature;

import java.util.HashMap;
import mod.azure.azurelib.core.object.Color;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.client.entity.texture.EggmorphLayerTexture;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import org.jetbrains.annotations.NotNull;

public class EggmorphFeatureRenderer<T extends class_1297, M extends class_583<T>>
extends class_3887<T, M> {
    private static int fovEggticker = 0;
    private static final HashMap<class_2960, EggmorphLayerTexture> textureCache = new HashMap();

    public EggmorphFeatureRenderer(class_3883<T, M> context) {
        super(context);
    }

    public static <T extends class_1297> void renderEggmorphedModel(class_583<T> renderedModel, class_2960 texture, class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        matrices.method_22903();
        renderedModel.method_2816(entity, limbAngle, limbDistance, tickDelta);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(EggmorphFeatureRenderer.getEggmorphLayerTexture((class_2960)texture).renderLayer);
        float progress = Math.clamp((CommonMod.config.getEggmorphTickTimer() / 2.0f - (float)fovEggticker) / (CommonMod.config.getEggmorphTickTimer() / 2.0f), -1.0f, 1.0f);
        int alpha = (int)(progress * 255.0f) << 24;
        vertexConsumer.method_39415(Color.ofOpaque((int)alpha).argbInt());
        renderedModel.method_2819(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        renderedModel.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, -1);
        matrices.method_22909();
    }

    public static EggmorphLayerTexture getEggmorphLayerTexture(class_2960 texture) {
        return textureCache.computeIfAbsent(texture, identifier -> new EggmorphLayerTexture(class_310.method_1551().method_1531(), class_310.method_1551().method_1478(), texture));
    }

    public void method_4199(@NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, int light, @NotNull T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_1309 livingEntity;
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_55667() != null && livingEntity.method_55667().method_26164(GigTags.NEST_CROSS_BLOCKS)) {
            if (livingEntity.field_6012 % 20 == 0) {
                ++fovEggticker;
            }
            if ((float)fovEggticker > CommonMod.config.getEggmorphTickTimer()) {
                fovEggticker = 0;
            }
            EggmorphFeatureRenderer.renderEggmorphedModel(this.method_17165(), this.method_23194((class_1297)entity), matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
        } else {
            fovEggticker = 0;
        }
    }
}

