/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import mods.cybercat.gigeresque.common.block.AbstractNestBlock;
import mods.cybercat.gigeresque.common.block.NestResinWebVariant;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestResinWebBlock
extends AbstractNestBlock {
    public static final class_2746 UP = class_2429.field_11327;
    public static final class_2746 NORTH = class_2429.field_11332;
    public static final class_2746 EAST = class_2429.field_11335;
    public static final class_2746 SOUTH = class_2429.field_11331;
    public static final class_2746 WEST = class_2429.field_11328;
    protected static final Map<class_2350, class_2746> FACING_PROPERTIES = (Map)class_2429.field_11329.entrySet().stream().filter(entry -> entry.getKey() != class_2350.field_11033).collect(class_156.method_664());
    public static final class_2754<NestResinWebVariant> VARIANTS = class_2754.method_11850((String)"nest_resin_web_variant", NestResinWebVariant.class);
    private static final class_265 UP_SHAPE = NestResinWebBlock.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_SHAPE = NestResinWebBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_SHAPE = NestResinWebBlock.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SOUTH_SHAPE = NestResinWebBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 NORTH_SHAPE = NestResinWebBlock.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> shapesByState;
    private final Random random = new Random();

    public NestResinWebBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657(VARIANTS, (Comparable)((Object)NestResinWebVariant.ONE)));
        this.shapesByState = this.method_9595().method_11662().stream().collect(Collectors.toMap(Function.identity(), NestResinWebBlock::getShapeForState));
    }

    private static class_265 getShapeForState(class_2680 state) {
        class_265 voxelShape = class_259.method_1073();
        if (Boolean.TRUE.equals(state.method_11654((class_2769)UP))) {
            voxelShape = UP_SHAPE;
        }
        if (Boolean.TRUE.equals(state.method_11654((class_2769)NORTH))) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SOUTH_SHAPE);
        }
        if (Boolean.TRUE.equals(state.method_11654((class_2769)SOUTH))) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)NORTH_SHAPE);
        }
        if (Boolean.TRUE.equals(state.method_11654((class_2769)EAST))) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)WEST_SHAPE);
        }
        if (Boolean.TRUE.equals(state.method_11654((class_2769)WEST))) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)EAST_SHAPE);
        }
        return voxelShape.method_1110() ? class_259.method_1077() : voxelShape;
    }

    public static boolean shouldConnectTo(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2680 blockState = world.method_8320(pos);
        return NestResinWebBlock.method_9501((class_265)blockState.method_26220((class_1922)world, pos), (class_2350)direction.method_10153());
    }

    public static class_2746 getFacingProperty(class_2350 direction) {
        return FACING_PROPERTIES.get(direction);
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return this.shapesByState.get(state);
    }

    public boolean method_9579(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos) {
        return true;
    }

    public boolean method_9558(@NotNull class_2680 state, @NotNull class_4538 world, @NotNull class_2338 pos) {
        return this.hasAdjacentBlocks(this.getPlacementShape(state, world, pos));
    }

    private boolean hasAdjacentBlocks(class_2680 state) {
        return this.getAdjacentBlockCount(state) > 0;
    }

    private int getAdjacentBlockCount(class_2680 state) {
        int[] i = new int[]{0};
        FACING_PROPERTIES.values().forEach(it -> {
            if (Boolean.TRUE.equals(state.method_11654((class_2769)it))) {
                i[0] = i[0] + 1;
            }
        });
        return i[0];
    }

    private boolean shouldHaveSide(class_4538 world, class_2338 pos, class_2350 side) {
        if (side == class_2350.field_11033) {
            return false;
        }
        class_2338 blockPos = pos.method_10093(side);
        if (NestResinWebBlock.shouldConnectTo(world, blockPos, side)) {
            return true;
        }
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        class_2680 blockState = world.method_8320(pos.method_10084());
        return blockState.method_27852((class_2248)this) && (Boolean)blockState.method_11654((class_2769)FACING_PROPERTIES.get(side)) != false;
    }

    private class_2680 getPlacementShape(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10084();
        if (Boolean.TRUE.equals(state.method_11654((class_2769)UP))) {
            state = (class_2680)state.method_11657((class_2769)UP, (Comparable)Boolean.valueOf(NestResinWebBlock.shouldConnectTo(world, blockPos, class_2350.field_11033)));
        }
        class_2680 blockState = null;
        Iterator iterator = class_2350.class_2353.field_11062.iterator();
        while (iterator.hasNext()) {
            class_2350 direction = (class_2350)iterator.next();
            class_2746 booleanProperty = NestResinWebBlock.getFacingProperty(direction);
            if (!Boolean.TRUE.equals(state.method_11654((class_2769)booleanProperty))) continue;
            boolean bl = this.shouldHaveSide(world, pos, direction);
            if (!bl) {
                if (blockState == null) {
                    blockState = world.method_8320(blockPos);
                }
                bl = blockState.method_27852((class_2248)this) && (Boolean)blockState.method_11654((class_2769)booleanProperty) != false;
            }
            state = (class_2680)state.method_11657((class_2769)booleanProperty, (Comparable)Boolean.valueOf(bl));
        }
        return state;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11033) {
            return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        }
        class_2680 blockState = this.getPlacementShape(state, (class_4538)world, pos);
        return !this.hasAdjacentBlocks(blockState) ? class_2246.field_10124.method_9564() : blockState;
    }

    public boolean method_9616(@NotNull class_2680 state, class_1750 context) {
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        return blockState.method_27852((class_2248)this) ? this.getAdjacentBlockCount(blockState) < FACING_PROPERTIES.size() : super.method_9616(state, context);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350[] placementDirections;
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        boolean bl = blockState.method_27852((class_2248)this);
        class_2680 blockState2 = bl ? blockState : this.method_9564();
        for (class_2350 direction : placementDirections = ctx.method_7718()) {
            boolean bl2;
            if (direction == class_2350.field_11033) continue;
            class_2746 booleanProperty = NestResinWebBlock.getFacingProperty(direction);
            boolean bl3 = bl2 = bl && (Boolean)blockState.method_11654((class_2769)booleanProperty) != false;
            if (bl2 || !this.shouldHaveSide((class_4538)ctx.method_8045(), ctx.method_8037(), direction)) continue;
            return (class_2680)((class_2680)blockState2.method_11657((class_2769)booleanProperty, (Comparable)Boolean.valueOf(true))).method_11657(VARIANTS, (Comparable)((Object)Arrays.stream(NestResinWebVariant.values()).toList().get(this.random.nextInt(NestResinWebVariant.values().length))));
        }
        return bl ? blockState2 : null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{UP, NORTH, EAST, SOUTH, WEST, VARIANTS});
    }

    @NotNull
    public class_2680 method_9598(@NotNull class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            default -> state;
        };
    }

    @NotNull
    public class_2680 method_9569(@NotNull class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            default -> super.method_9569(state, mirror);
        };
    }
}

