/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.movement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.BlockBreakProgressManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;

public class DigToTargetGoal
extends class_1352 {
    private final AlienEntity mob;
    private final double reachDistance;
    private final double maxDistanceFromTarget;
    private final List<class_2338> targetBlocks = new ArrayList<class_2338>();
    private class_2680 blockState = null;
    private class_243 lastPosition = null;
    private int lastPositionTickstamp = 0;

    public DigToTargetGoal(AlienEntity mob) {
        this(mob, 16.0);
    }

    public DigToTargetGoal(AlienEntity mob, double maxDistanceFromTarget) {
        this.mob = mob;
        this.reachDistance = 4.0;
        this.maxDistanceFromTarget = maxDistanceFromTarget * maxDistanceFromTarget;
    }

    public boolean method_6264() {
        if (!this.mob.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            return false;
        }
        if (this.mob.method_5968() == null) {
            return false;
        }
        return this.isStuck() && (this.mob.method_5858((class_1297)this.mob.method_5968()) > 2.0 || !this.mob.method_6057((class_1297)this.mob.method_5968())) && this.mob.method_5858((class_1297)this.mob.method_5968()) < this.maxDistanceFromTarget;
    }

    public boolean method_6266() {
        if (this.targetBlocks.isEmpty()) {
            return false;
        }
        class_1309 target = this.mob.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (this.mob.method_5782()) {
            return false;
        }
        return this.targetBlocks.getFirst().method_10262((class_2382)this.mob.method_24515()) < this.reachDistance * this.reachDistance && !this.mob.method_37908().method_8320(this.targetBlocks.getFirst()).method_26215();
    }

    public void method_6269() {
        class_1309 target = this.mob.method_5968();
        if (target == null) {
            return;
        }
        this.gatherTargetBlocks(target);
        if (!this.targetBlocks.isEmpty()) {
            this.initBlockBreak();
            this.mob.method_19540(true);
        }
    }

    public void method_6270() {
        if (!this.targetBlocks.isEmpty()) {
            this.targetBlocks.clear();
        }
        this.blockState = null;
        this.lastPosition = null;
        this.mob.method_19540(false);
    }

    public void method_6268() {
        float damage;
        class_1309 target = this.mob.method_5968();
        if (this.targetBlocks.isEmpty() || target == null) {
            return;
        }
        class_2338 pos = this.targetBlocks.getFirst();
        this.mob.method_5988().method_20248((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        class_1324 attackAttribute = this.mob.method_5996(class_5134.field_23721);
        float f = damage = attackAttribute == null ? 10.0f : (float)attackAttribute.method_6194() * 2.0f;
        if (this.mob.field_6012 % 4 == 0 && this.mob.method_37908().method_8320(pos).method_26164(GigTags.WEAK_BLOCKS)) {
            this.mob.animationSelector.select(this.mob);
            BlockBreakProgressManager.damage(this.mob.method_37908(), pos, damage);
            class_2498 soundType = this.blockState.method_26231();
            this.mob.method_37908().method_8396(null, pos, soundType.method_10596(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 8.0f, soundType.method_10599() * 0.5f);
        } else if (this.mob.field_6012 % 20 == 0) {
            this.mob.animationSelector.select(this.mob);
            class_1297 acidEntity = GigEntities.ACID.get().method_5883(this.mob.method_37908());
            if (acidEntity != null) {
                acidEntity.method_5814((double)pos.method_10263(), (double)(pos.method_10264() + 1), (double)pos.method_10260());
                this.mob.method_37908().method_8649(acidEntity);
            }
        }
        if (this.mob.method_37908().method_8320(pos).method_27852(class_2246.field_10124)) {
            this.targetBlocks.removeFirst();
            if (!this.targetBlocks.isEmpty()) {
                this.initBlockBreak();
            } else if (this.mob.method_5858((class_1297)target) > 2.0 && !this.mob.method_5985().method_6369((class_1297)target)) {
                this.method_6269();
            }
        }
    }

    private void initBlockBreak() {
        this.blockState = this.mob.method_37908().method_8320(this.targetBlocks.getFirst());
    }

    private void gatherTargetBlocks(@NotNull class_1309 target) {
        int mobWidth = class_3532.method_15386((float)this.mob.method_17681());
        int mobHeight = class_3532.method_15386((float)this.mob.method_17682());
        for (int i = 0; i < mobHeight; ++i) {
            for (int j = -mobWidth / 2; j <= mobWidth / 2; ++j) {
                for (int k = -mobWidth / 2; k <= mobWidth / 2; ++k) {
                    class_2680 state;
                    double distance;
                    class_243 from = this.mob.method_19538().method_1031((double)j, (double)i + 0.5, (double)k);
                    class_243 to = target.method_5836(1.0f).method_1031((double)j, (double)i, (double)k);
                    class_3959 clipContext = new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.mob);
                    class_3965 rayTraceResult = this.mob.method_37908().method_17742(clipContext);
                    if (rayTraceResult.method_17783() == class_239.class_240.field_1333 || this.targetBlocks.contains(rayTraceResult.method_17777()) || rayTraceResult.method_17777().method_10264() > 320 || (distance = this.mob.method_5707(rayTraceResult.method_17784())) > this.reachDistance * this.reachDistance || (state = this.mob.method_37908().method_8320(rayTraceResult.method_17777())).method_31709() || state.method_26214((class_1922)this.mob.method_37908(), rayTraceResult.method_17777()) == -1.0f || state.method_26204().method_36555() >= class_2246.field_10085.method_36555()) continue;
                    this.targetBlocks.add(rayTraceResult.method_17777());
                }
            }
        }
        Collections.reverse(this.targetBlocks);
    }

    public boolean method_38846() {
        return true;
    }

    public boolean isStuck() {
        if (this.mob.method_5968() == null) {
            return false;
        }
        if (this.mob.method_5739((class_1297)this.mob.method_5968()) <= this.mob.method_17681()) {
            return false;
        }
        if (this.lastPosition == null || this.mob.method_5707(this.lastPosition) > 2.25) {
            this.lastPosition = this.mob.method_19538();
            this.lastPositionTickstamp = this.mob.field_6012;
        }
        return this.mob.method_5942().method_6357() || this.mob.field_6012 - this.lastPositionTickstamp >= 60;
    }
}

