/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper;

import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.particle.GigParticles;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.helper.states.EggStates;
import mods.cybercat.gigeresque.common.entity.impl.classic.AlienEggEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_5819;
import net.minecraft.class_6862;

public record GigCommonMethods() {
    public static void setAnimation(Runnable animationAction) {
        animationAction.run();
    }

    public static class_1297 generateBloodPool(class_1309 entity, class_2338 pos, int xOffset, int zOffset) {
        class_1297 bloodEntity = GigEntities.BLOOD.get().method_5883(entity.method_37908());
        assert (bloodEntity != null);
        bloodEntity.method_5725(pos.method_10069(xOffset, 0, zOffset), entity.method_36454(), entity.method_36455());
        entity.method_37908().method_8649(bloodEntity);
        return bloodEntity;
    }

    public static class_1297 generateAcidPool(class_1309 entity, class_2338 pos, int xOffset, int zOffset) {
        class_1297 acidEntity = GigEntities.ACID.get().method_5883(entity.method_37908());
        assert (acidEntity != null);
        acidEntity.method_5725(pos.method_10069(xOffset, 0, zOffset), entity.method_36454(), entity.method_36455());
        entity.method_37908().method_8649(acidEntity);
        return acidEntity;
    }

    public static class_1297 generateAcidPoolAtPos(class_1937 level, class_2338 pos, int xOffset, int zOffset) {
        class_1297 acidEntity = GigEntities.ACID.get().method_5883(level);
        assert (acidEntity != null);
        acidEntity.method_5725(pos.method_10069(0, 1, 0), (float)xOffset, (float)zOffset);
        level.method_8649(acidEntity);
        return acidEntity;
    }

    public static class_1297 generateGooBlood(class_1309 entity, class_2338 pos, int xOffset, int zOffset) {
        class_1297 gooEntity = GigEntities.GOO.get().method_5883(entity.method_37908());
        assert (gooEntity != null);
        gooEntity.method_5725(pos.method_10069(xOffset, 0, zOffset), entity.method_36454(), entity.method_36455());
        entity.method_37908().method_8649(gooEntity);
        return gooEntity;
    }

    public static class_1297 generateGooBloodAtPos(class_1937 level, class_2338 pos, int xOffset, int zOffset) {
        class_1297 gooEntity = GigEntities.GOO.get().method_5883(level);
        assert (gooEntity != null);
        gooEntity.method_5725(pos.method_10069(0, 1, 0), (float)xOffset, (float)zOffset);
        level.method_8649(gooEntity);
        return gooEntity;
    }

    public static class_1297 generateSporeCloud(class_1309 entity, class_2338 pos, int xOffset, int zOffset, float radius) {
        class_1295 areaEffectCloudEntity = new class_1295(entity.method_37908(), (double)pos.method_10263(), (double)pos.method_10264() + 0.5, (double)pos.method_10260());
        areaEffectCloudEntity.method_5603(radius);
        areaEffectCloudEntity.method_5604(150);
        areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
        areaEffectCloudEntity.method_5608((class_2394)class_2398.field_22247);
        if (!entity.method_6059(GigStatusEffects.SPORE)) {
            areaEffectCloudEntity.method_5610(new class_1293(GigStatusEffects.SPORE, CommonMod.config.sporeTickTimer, 0));
        }
        entity.method_37908().method_8649((class_1297)areaEffectCloudEntity);
        return areaEffectCloudEntity;
    }

    public static void handleNestProgress(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.getEggState() == EggStates.HATCHED.ordinal() && alienEggEntity.method_5805()) {
            float f = alienEggEntity.ticksUntilNest;
            alienEggEntity.ticksUntilNest = f + 1.0f;
            alienEggEntity.setTicksUntilNest(f);
            if (alienEggEntity.getTicksUntilNest() >= 6000.0f) {
                if (alienEggEntity.method_37908().field_9236) {
                    GigCommonMethods.spawnParticlesForNesting(alienEggEntity);
                }
                alienEggEntity.method_37908().method_8501(alienEggEntity.method_24515(), GigBlocks.NEST_RESIN_WEB_CROSS.get().method_9564());
                alienEggEntity.method_5768();
            }
        }
    }

    public static void spawnParticlesForNesting(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.getTicksUntilNest() == 6000.0f) {
            for (int i = 0; i < 2; ++i) {
                alienEggEntity.method_37908().method_8494((class_2394)GigParticles.GOO.get(), alienEggEntity.method_23322(1.0), alienEggEntity.method_23319(), alienEggEntity.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void handleHatchingProgress(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.getEggState() == EggStates.HATCHING.ordinal()) {
            if (alienEggEntity.hatchProgress < 50L) {
                ++alienEggEntity.hatchProgress;
            }
            if (alienEggEntity.hatchProgress == 2L) {
                alienEggEntity.method_37908().method_45445((class_1297)alienEggEntity, alienEggEntity.method_24515(), GigSounds.EGG_OPEN.get(), class_3419.field_15251, 1.0f, 1.0f);
            }
            if (alienEggEntity.hatchProgress >= 50L) {
                alienEggEntity.setEggState(EggStates.HATCHED.ordinal());
                ++alienEggEntity.ticksOpen;
            }
        }
        if (alienEggEntity.getEggState() == EggStates.HATCHED.ordinal() && alienEggEntity.hasFacehugger()) {
            ++alienEggEntity.ticksOpen;
        }
    }

    public static void handleFacehuggerSpawn(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.ticksOpen >= 60L && alienEggEntity.hasFacehugger() && !alienEggEntity.method_29504()) {
            FacehuggerEntity facehugger = (FacehuggerEntity)GigEntities.FACEHUGGER.get().method_5883(alienEggEntity.method_37908());
            if (facehugger != null) {
                facehugger.method_5814(alienEggEntity.method_19538().field_1352, alienEggEntity.method_19538().field_1351 + 1.0, alienEggEntity.method_19538().field_1350);
                facehugger.method_18800(class_3532.method_15344((class_5819)facehugger.method_59922(), (float)-0.5f, (float)0.5f), 0.7, class_3532.method_15344((class_5819)facehugger.method_59922(), (float)-0.5f, (float)0.5f));
                alienEggEntity.method_37908().method_8649((class_1297)facehugger);
            }
            alienEggEntity.setHasFacehugger(false);
        }
    }

    public static void handleAoEEntityHatchCheck(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.hatchCheckTimer >= 20) {
            alienEggEntity.hatchCheckTimer = 0;
            alienEggEntity.method_37908().method_18467(class_1309.class, alienEggEntity.method_5829().method_1014(CommonMod.config.eggConfigs.alieneggHatchRange)).forEach(target -> {
                if (target.method_5805() && GigEntityUtils.faceHuggerTest(target) && alienEggEntity.method_37908().field_9229.method_43057() < 0.2f && !target.method_21749() && Constants.isNotCreativeSpecPlayer.test((class_1297)target)) {
                    alienEggEntity.setEggState(EggStates.HATCHING.ordinal());
                }
            });
            alienEggEntity.method_37908().method_18467(class_1309.class, alienEggEntity.method_5829().method_1014(3.0)).forEach(target -> {
                class_1657 player;
                if (target.method_5805() && GigEntityUtils.faceHuggerTest(target) && alienEggEntity.method_37908().field_9229.method_43057() < 0.8f && (target instanceof class_1657 && !(player = (class_1657)target).method_7337() && !player.method_7325() || !(target instanceof class_1657))) {
                    alienEggEntity.setEggState(EggStates.HATCHING.ordinal());
                }
            });
        }
    }

    public static void handleAoEBlockHatchCheck(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.method_6052() == null) {
            for (class_2338 testPos : class_2338.method_10097((class_2338)alienEggEntity.method_24515().method_10086(1), (class_2338)alienEggEntity.method_24515().method_10086(1))) {
                for (class_2338 testPos1 : class_2338.method_10097((class_2338)alienEggEntity.method_24515().method_10087(1), (class_2338)alienEggEntity.method_24515().method_10087(1))) {
                    for (class_2338 testPos2 : class_2338.method_10097((class_2338)alienEggEntity.method_24515().method_10089(1), (class_2338)alienEggEntity.method_24515().method_10089(1))) {
                        for (class_2338 testPos3 : class_2338.method_10097((class_2338)alienEggEntity.method_24515().method_10088(1), (class_2338)alienEggEntity.method_24515().method_10088(1))) {
                            for (class_2338 testPos4 : class_2338.method_10097((class_2338)alienEggEntity.method_24515().method_10077(1), (class_2338)alienEggEntity.method_24515().method_10077(1))) {
                                for (class_2338 testPos5 : class_2338.method_10097((class_2338)alienEggEntity.method_24515().method_10076(1), (class_2338)alienEggEntity.method_24515().method_10076(1))) {
                                    boolean isAnyBlockSolid;
                                    boolean isAnyBlockNotAir = !alienEggEntity.method_37908().method_8320(testPos).method_26215() && !alienEggEntity.method_37908().method_8320(testPos1).method_26215() && !alienEggEntity.method_37908().method_8320(testPos2).method_26215() && !alienEggEntity.method_37908().method_8320(testPos3).method_26215() && !alienEggEntity.method_37908().method_8320(testPos4).method_26215() && !alienEggEntity.method_37908().method_8320(testPos5).method_26215();
                                    boolean bl = isAnyBlockSolid = !alienEggEntity.method_37908().method_8320(testPos).method_26234((class_1922)alienEggEntity.method_37908(), testPos) && !alienEggEntity.method_37908().method_8320(testPos1).method_26234((class_1922)alienEggEntity.method_37908(), testPos1) && !alienEggEntity.method_37908().method_8320(testPos2).method_26234((class_1922)alienEggEntity.method_37908(), testPos2) && !alienEggEntity.method_37908().method_8320(testPos3).method_26234((class_1922)alienEggEntity.method_37908(), testPos3) && !alienEggEntity.method_37908().method_8320(testPos4).method_26234((class_1922)alienEggEntity.method_37908(), testPos4) && !alienEggEntity.method_37908().method_8320(testPos5).method_26234((class_1922)alienEggEntity.method_37908(), testPos5);
                                    if (!isAnyBlockSolid && !isAnyBlockNotAir) continue;
                                    alienEggEntity.setEggState(EggStates.IDLE.ordinal());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static void handlePlayerInteraction(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.method_6052() != null) {
            alienEggEntity.setEggState(EggStates.HATCHING.ordinal());
        }
    }

    public static void handleFloatingPhysics(class_1297 alienEgg) {
        alienEgg.field_6014 = alienEgg.method_23317();
        alienEgg.field_6036 = alienEgg.method_23318();
        alienEgg.field_5969 = alienEgg.method_23321();
        class_243 motion = alienEgg.method_18798();
        double adjustedY = motion.field_1351 + (double)(motion.field_1351 < (double)0.06f ? 5.0E-4f : 0.0f);
        if (GigCommonMethods.isFloatingInFluid(alienEgg, (class_6862<class_3611>)class_3486.field_15517) || GigCommonMethods.isFloatingInFluid(alienEgg, (class_6862<class_3611>)class_3486.field_15518)) {
            alienEgg.method_18800(motion.field_1352 * 0.99, adjustedY, motion.field_1350 * 0.99);
        } else {
            alienEgg.method_56990();
        }
    }

    public static boolean isFloatingInFluid(class_1297 alienEgg, class_6862<class_3611> fluidTag) {
        return alienEgg.method_5799() && alienEgg.method_5861(fluidTag) > 0.1;
    }

    public static void handleCollisionPhysics(class_1297 alienEgg) {
        if (alienEgg.method_37908().field_9236) {
            alienEgg.field_5960 = false;
        } else {
            boolean bl = alienEgg.field_5960 = !alienEgg.method_37908().method_8587(alienEgg, alienEgg.method_5829().method_1011(1.0E-7));
            if (alienEgg.field_5960) {
                GigCommonMethods.moveToClosestSpace(alienEgg);
            }
        }
    }

    public static void moveToClosestSpace(class_1297 alienEgg) {
        alienEgg.method_5632(alienEgg.method_23317(), (alienEgg.method_5829().field_1322 + alienEgg.method_5829().field_1325) / 1.5, alienEgg.method_23321());
    }

    public static void handleMovement(class_1297 alienEgg) {
        if (GigCommonMethods.shouldApplyMovement(alienEgg)) {
            alienEgg.method_5784(class_1313.field_6308, alienEgg.method_18798());
            float friction = GigCommonMethods.getGroundFriction(alienEgg);
            alienEgg.method_18799(alienEgg.method_18798().method_18805((double)friction, 0.78, (double)friction));
            GigCommonMethods.handleGroundImpact(alienEgg);
        }
    }

    public static boolean shouldApplyMovement(class_1297 alienEgg) {
        return !alienEgg.method_24828() || alienEgg.method_18798().method_37268() > 1.0E-5 || (alienEgg.field_6012 + alienEgg.method_5628()) % 4 == 0;
    }

    public static float getGroundFriction(class_1297 alienEgg) {
        if (alienEgg.method_24828()) {
            return alienEgg.method_37908().method_8320(alienEgg.method_23314()).method_26204().method_9499() * 0.98f;
        }
        return 0.98f;
    }

    public static void handleGroundImpact(class_1297 alienEgg) {
        if (alienEgg.method_24828()) {
            class_243 motion = alienEgg.method_18798();
            if (motion.field_1351 < 0.0) {
                alienEgg.method_18799(motion.method_18805(1.0, -0.1, 1.0));
            }
        }
    }
}

