/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.worlddata;

import java.util.List;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.worlddata.PandoraData;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5304;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_8779;
import org.jetbrains.annotations.NotNull;

public class PandoraEffect
implements class_5304 {
    private int nextTick = 0;

    public int method_6445(@NotNull class_3218 level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!(PandoraData.isTriggered() && spawnEnemies && level.method_8450().method_8355(class_1928.field_21831) && CommonMod.config.enablePandoraEffects)) {
            return 0;
        }
        if (!PandoraData.isTriggered()) {
            return 0;
        }
        if (--this.nextTick > 0) {
            return 0;
        }
        this.nextTick = 6000 + level.field_9229.method_43048(200);
        class_5819 randomSource = level.field_9229;
        class_1657 player = this.getRandomPlayer(level);
        if (player == null) {
            return 0;
        }
        class_2338 playerPos = player.method_24515();
        if (player.method_37908().method_8320(playerPos).method_26164(GigTags.DUNGEON_BLOCKS)) {
            return 0;
        }
        if (level.method_22339(player.method_24515()) >= 8) {
            if (CommonMod.config.enableLogging) {
                CommonMod.LOGGER.warn("Failed to spawn entity: Light level at {} is too high ({}).", (Object)player.method_24515(), (Object)player.method_37908().method_8314(class_1944.field_9284, player.method_24515()));
            }
            return 0;
        }
        class_2338 mutableBlockPos = this.getRandomNearbyPosition(player, randomSource);
        if (!this.isValidSpawnLocation(mutableBlockPos, level)) {
            return 0;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_8779 advancement = serverPlayer.field_13995.method_3851().method_12896(Constants.modResource("firstspawnfromeffect"));
            if (advancement != null && !serverPlayer.method_14236().method_12882(advancement).method_740()) {
                for (String s : serverPlayer.method_14236().method_12882(advancement).method_731()) {
                    serverPlayer.method_14236().method_12878(advancement, s);
                }
            }
        }
        return this.spawnEggs(level, mutableBlockPos);
    }

    private boolean isValidSpawnTime(class_3218 level) {
        return level.field_9229.method_43048(5) == 0;
    }

    private class_1657 getRandomPlayer(class_3218 level) {
        List players = level.method_18456();
        if (players.isEmpty()) {
            return null;
        }
        class_3222 player = (class_3222)players.get(level.field_9229.method_43048(players.size()));
        if (player.method_7325()) {
            CommonMod.LOGGER.warn("Excluded player {} because they are in Spectator mode.", (Object)player.method_5477().getString());
            return null;
        }
        return player;
    }

    private class_2338 getRandomNearbyPosition(class_1657 player, class_5819 randomSource) {
        int xOffset = (24 + randomSource.method_43048(24)) * (randomSource.method_43056() ? -1 : 1);
        int zOffset = (24 + randomSource.method_43048(24)) * (randomSource.method_43056() ? -1 : 1);
        return player.method_24515().method_25503().method_10100(xOffset, 0, zOffset);
    }

    private boolean isValidSpawnLocation(class_2338 pos, class_3218 level) {
        if (!level.method_33597(pos.method_10263() - 10, pos.method_10260() - 10, pos.method_10263() + 10, pos.method_10260() + 10)) {
            return false;
        }
        if (level.method_22339(pos) >= 8) {
            return false;
        }
        class_6880 biomeHolder = level.method_23753(pos);
        return biomeHolder.method_40220(class_6908.field_37393);
    }

    private int spawnEggs(class_3218 level, class_2338 startPos) {
        class_5819 randomSource = level.field_9229;
        startPos.method_10099(level.method_8598(class_2902.class_2903.field_13203, startPos).method_10264());
        this.spawnEgg(level, startPos);
        startPos.method_20787(startPos.method_10263() + randomSource.method_43048(5) - randomSource.method_43048(5));
        startPos.method_20788(startPos.method_10260() + randomSource.method_43048(5) - randomSource.method_43048(5));
        return 1;
    }

    private void spawnEgg(class_3218 level, class_2338 pos) {
        class_2680 belowState = level.method_8320(pos.method_10074());
        if (!belowState.method_27852(class_2246.field_10219)) {
            return;
        }
        boolean isWaterBiome = level.method_23753(pos).method_40220(GigTags.AQUASPAWN_BIOMES);
        class_1297 eggEntity = isWaterBiome ? GigEntities.AQUA_EGG.get().method_5883((class_1937)level) : GigEntities.EGG.get().method_5883((class_1937)level);
        eggEntity.method_5814((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        if (CommonMod.config.enableLogging) {
            eggEntity.method_5834(true);
            CommonMod.LOGGER.info("Spawned Pandora {} at {}, {}, {}", (Object)eggEntity.method_5476().getString(), (Object)pos.method_10263(), (Object)pos.method_10264(), (Object)pos.method_10260());
        }
        level.method_30771(eggEntity);
    }
}

