/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block.petrifiedblocks;

import mods.cybercat.gigeresque.common.block.GigBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PetrifiedStatueInvisBlock
extends Block {
    private static final VoxelShape OUTLINE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public PetrifiedStatueInvisBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(30.0f, 15.0f).noOcclusion().noLootTable());
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (world.isClientSide) {
            return state;
        }
        Vec3i radius = new Vec3i(2, 2, 2);
        for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)pos.subtract(radius), (BlockPos)pos.offset(radius))) {
            BlockState testState = world.getBlockState(testPos);
            if (testState.is((Block)GigBlocks.PETRIFIED_STATUE_BLOCK.get())) {
                world.destroyBlock(testPos, true);
                Block.dropResources((BlockState)testState, (Level)world, (BlockPos)testPos);
                continue;
            }
            if (!testState.is((Block)this)) continue;
            world.setBlock(testPos, Blocks.AIR.defaultBlockState(), 3);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return OUTLINE_SHAPE;
    }
}

