/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.EnumSet;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BreakBlocksGoal
extends Goal {
    protected final AlienEntity alienEntity;
    private BlockPos targetPos = BlockPos.ZERO;
    private BlockState targetBlock;
    private BlockHitResult targetHitResult;
    private boolean canReach;
    private int sightCounter;
    private int giveUpDelay;
    private final TagKey<Block> blockTagKey;
    private final float range;

    public BreakBlocksGoal(AlienEntity alienEntity, TagKey<Block> blockTagKey, float range) {
        this.alienEntity = alienEntity;
        this.blockTagKey = blockTagKey;
        this.range = range;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.alienEntity.isPassenger() || !this.alienEntity.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (this.alienEntity.isBirthed() || this.alienEntity.getGrowth() < 10.0f) {
            return false;
        }
        --this.sightCounter;
        if (this.sightCounter <= 0) {
            this.sightCounter = 2;
            int rangeXZ = 12;
            int rangeY = 6;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 32; ++i) {
                pos.set(this.alienEntity.blockPosition().getX() + this.alienEntity.getRandom().nextInt(12) - this.alienEntity.getRandom().nextInt(12), this.alienEntity.blockPosition().getY() + this.alienEntity.getRandom().nextInt(6) - this.alienEntity.getRandom().nextInt(6), this.alienEntity.blockPosition().getZ() + this.alienEntity.getRandom().nextInt(12) - this.alienEntity.getRandom().nextInt(12));
                if (!this.tryTargetBlock((BlockPos)pos)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.alienEntity.isPassenger() || !this.alienEntity.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (this.alienEntity.isBirthed() || this.alienEntity.getGrowth() < 10.0f) {
            return false;
        }
        return this.giveUpDelay < 40;
    }

    public boolean isInterruptable() {
        return this.alienEntity.isFleeing();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        this.alienEntity.setAggressive(false);
        this.targetHitResult = null;
        this.canReach = false;
        this.sightCounter = 0;
        this.giveUpDelay = 0;
        this.pathToTarget();
    }

    public void stop() {
        this.alienEntity.setAggressive(false);
        this.targetBlock = null;
        this.targetHitResult = null;
        this.canReach = false;
        this.sightCounter = 20;
        this.giveUpDelay = 0;
        this.alienEntity.level().destroyBlockProgress(this.alienEntity.getId(), this.targetPos, -1);
    }

    public void tick() {
        ++this.giveUpDelay;
        if (this.targetPos != null) {
            this.alienEntity.getLookControl().setLookAt((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, 30.0f, 30.0f);
        }
        if (this.canReach && this.targetHitResult != null && this.targetBlock != null) {
            this.performGriefing();
        } else {
            if (this.sightCounter-- <= 0) {
                this.sightCounter = 8 + this.alienEntity.getRandom().nextInt(5);
                if (this.checkSight()) {
                    this.sightCounter += 5;
                }
            }
            if (this.giveUpDelay > 400) {
                this.targetBlock = null;
            } else if (this.alienEntity.getNavigation().isDone()) {
                this.pathToTarget();
            }
        }
    }

    private void pathToTarget() {
        this.alienEntity.getNavigation().moveTo((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, 1.0);
    }

    private boolean tryTargetBlock(BlockPos pos) {
        BlockState block = this.alienEntity.level().getBlockState(pos);
        if (block.isAir()) {
            return false;
        }
        return this.tryTargetBlockGriefing(block, pos);
    }

    private boolean checkSight() {
        double x = (double)this.targetPos.getX() + 0.5;
        double y = (double)this.targetPos.getY() + 0.5;
        double z = (double)this.targetPos.getZ() + 0.5;
        if (this.alienEntity.distanceToSqr(x, y - (double)this.alienEntity.getEyeHeight(), z) <= (double)(this.range * this.range)) {
            Vec3 posVec = new Vec3(this.alienEntity.getX(), this.alienEntity.getY() + (double)this.alienEntity.getEyeHeight(), this.alienEntity.getZ());
            if (this.checkSight(posVec, x, y + (this.alienEntity.getY() > y ? 0.5 : -0.5), z) || this.checkSight(posVec, x + (this.alienEntity.getX() > x ? 0.5 : -0.5), y, z) || this.checkSight(posVec, x, y, z + (this.alienEntity.getZ() > z ? 0.5 : -0.5))) {
                this.canReach = true;
            }
            return true;
        }
        return false;
    }

    private boolean checkSight(Vec3 posVec, double x, double y, double z) {
        Vec3 targetVec = new Vec3(x, y, z);
        BlockHitResult hit = this.alienEntity.level().clip(new ClipContext(posVec, targetVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.alienEntity));
        if (HitResult.Type.MISS.equals((Object)hit.getType())) {
            hit = new BlockHitResult(hit.getLocation(), hit.getDirection(), hit.getBlockPos(), hit.isInside());
        }
        if (this.targetPos.equals((Object)hit.getBlockPos()) || this.tryTargetObstructingBlock(hit)) {
            this.targetHitResult = hit;
            return true;
        }
        return false;
    }

    private boolean tryTargetObstructingBlock(BlockHitResult hit) {
        BlockState block = this.alienEntity.level().getBlockState(hit.getBlockPos());
        return this.tryTargetBlockGriefing(block, hit.getBlockPos());
    }

    private boolean tryTargetBlockGriefing(BlockState block, BlockPos pos) {
        if (block.is(this.blockTagKey)) {
            this.targetPos = pos.immutable();
            this.targetBlock = block;
            return true;
        }
        return false;
    }

    private void performGriefing() {
        if (this.alienEntity.getNavigation().isInProgress()) {
            this.alienEntity.getNavigation().stop();
        }
        Level level = this.alienEntity.level();
        level.destroyBlock(this.targetPos, true);
        level.playSound((Entity)this.alienEntity, this.alienEntity.blockPosition(), this.targetBlock.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!this.alienEntity.swinging) {
            this.alienEntity.swing(this.alienEntity.getUsedItemHand());
            this.alienEntity.animationSelector.select(this.alienEntity);
        }
        this.targetBlock = null;
    }
}

