/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedAttackGoal;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;

public class FacehuggerRunToTargetGoal
extends DelayedAttackGoal {
    public FacehuggerRunToTargetGoal(AlienEntity mob, double speedModifier, int delayTicksBeforeAttack) {
        super(mob, speedModifier, delayTicksBeforeAttack);
    }

    @Override
    protected boolean isAbleToAttack() {
        if (this.alienEntity.hasEffect(MobEffects.CONFUSION)) {
            return false;
        }
        if (this.alienEntity.isVehicle() || this.alienEntity.getTarget() == null) {
            return false;
        }
        if (this.alienEntity.getTarget().getType().is(GigTags.FACEHUGGER_BLACKLIST) || !GigEntityUtils.isTargetHostable((Entity)this.alienEntity.getTarget())) {
            return false;
        }
        return !NEST.test(this.alienEntity.getTarget().getInBlockState());
    }

    @Override
    public void tick() {
        super.tick();
        this.attackAnimationCooldown.tick();
        if (this.alienEntity.getTarget() != null && this.ranAttackAnimation && !this.attackAnimationCooldown.isActive() && this.alienEntity.getSensing().hasLineOfSight((Entity)this.alienEntity.getTarget())) {
            this.resetAttackCooldown();
            this.ranAttackAnimation = false;
        }
    }
}

