/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.EnumSet;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LungeAtTargetGoal
extends Goal {
    private static final int DEFAULT_WIND_UP_TIME_IN_TICKS = 10;
    private static final float DEFAULT_DISTANCE_TARGET = -1.0f;
    private final Mob mob;
    private final int maxCooldown;
    private final float normalizedChance;
    private final double minLungeRange = 1.0;
    private final double maxLungeRange;
    private float distanceToTarget;
    private int windUpTimeInTicks;
    private int cooldown;
    @Nullable
    Runnable onLungeCallback;

    public LungeAtTargetGoal(Mob mob, float normalizedChance, int cooldown, double maxLungeRange) {
        this.mob = mob;
        this.maxCooldown = cooldown;
        this.normalizedChance = normalizedChance;
        this.maxLungeRange = maxLungeRange;
        this.cooldown = 0;
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.cooldown = Math.max(this.cooldown - 1, 0);
        boolean canUse = !this.isOnCooldown() && this.mob.getRandom().nextFloat() < this.normalizedChance;
        return this.mob.getTarget() != null && this.mob.onGround() && this.isInRange() && canUse && this.mob.getSensing().hasLineOfSight((Entity)this.mob.getTarget());
    }

    public boolean canContinueToUse() {
        return this.mob.getTarget() != null && this.mob.onGround() && this.mob.getSensing().hasLineOfSight((Entity)this.mob.getTarget());
    }

    public void start() {
        super.start();
        if (this.mob.getTarget() != null) {
            this.mob.getLookControl().setLookAt((Entity)this.mob.getTarget(), 180.0f, 180.0f);
        }
    }

    public void tick() {
        if (this.mob.getTarget() == null) {
            return;
        }
        LivingEntity target = this.mob.getTarget();
        this.mob.getLookControl().setLookAt((Entity)target, 180.0f, 180.0f);
        float currentDistanceToTarget = this.mob.distanceTo((Entity)target);
        if (this.distanceToTarget == -1.0f) {
            this.distanceToTarget = currentDistanceToTarget;
        }
        if (this.mob.getLastHurtByMobTimestamp() > 0 && this.mob.tickCount - this.mob.getLastHurtByMobTimestamp() < 20 || currentDistanceToTarget > this.distanceToTarget) {
            this.windUpTimeInTicks = 0;
        }
        if (this.windUpTimeInTicks > 0) {
            --this.windUpTimeInTicks;
            return;
        }
        this.distanceToTarget = currentDistanceToTarget;
        Vec3 deltaMovement = this.mob.getDeltaMovement().scale(0.2);
        Vec3 vectorDifference = target.getEyePosition().subtract(this.mob.getEyePosition());
        vectorDifference = vectorDifference.normalize().scale(0.2 * (double)this.distanceToTarget).add(deltaMovement.x, 0.0, deltaMovement.z);
        this.mob.setDeltaMovement(vectorDifference.x, Math.max(0.6, vectorDifference.y), vectorDifference.z);
        if (this.onLungeCallback != null) {
            this.onLungeCallback.run();
        }
        this.resetWindUpTimeInTicks();
        this.resetCooldown();
    }

    public void stop() {
        super.stop();
        this.resetCooldown();
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
        Mob mob = this.mob;
        if (mob instanceof FacehuggerEntity) {
            FacehuggerEntity facehuggerEntity = (FacehuggerEntity)mob;
            facehuggerEntity.animationDispatcher.sendIdle();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public LungeAtTargetGoal setOnLungeCallback(@Nullable Runnable onLungeCallback) {
        this.onLungeCallback = onLungeCallback;
        return this;
    }

    private boolean isOnCooldown() {
        return this.cooldown > 0;
    }

    private void resetCooldown() {
        this.cooldown = this.maxCooldown;
    }

    private void resetWindUpTimeInTicks() {
        this.windUpTimeInTicks = 10;
    }

    private boolean isInRange() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return false;
        }
        double distanceToHost = this.mob.distanceToSqr((Entity)target);
        double minimumRangeSquared = 1.0;
        double maximumRangeSquared = this.maxLungeRange * this.maxLungeRange;
        return distanceToHost <= maximumRangeSquared && distanceToHost >= minimumRangeSquared;
    }
}

