/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedAttackGoal;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class SpitAcidGoal
extends DelayedAttackGoal {
    public SpitAcidGoal(AlienEntity alienEntity, double speedModifier, int delayTicksBeforeAttack) {
        super(alienEntity, speedModifier, delayTicksBeforeAttack);
    }

    @Override
    protected boolean isAbleToAttack() {
        LivingEntity livingentity = this.alienEntity.getTarget();
        if (this.alienEntity.isVehicle() || livingentity == null) {
            return false;
        }
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            return false;
        }
        return !NEST.test(livingentity.getInBlockState());
    }

    @Override
    public boolean canUse() {
        long i = this.mob.level().getGameTime();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
        return this.path != null || this.isAbleToAttack();
    }

    @Override
    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.isAbleToAttack();
    }

    @Override
    public void tick() {
        super.tick();
        this.attackAnimationCooldown.tick();
        if (this.ranAttackAnimation && !this.attackAnimationCooldown.isActive() && this.alienEntity.getSensing().hasLineOfSight((Entity)this.alienEntity.getTarget())) {
            this.resetAttackCooldown();
            this.alienEntity.swing(InteractionHand.MAIN_HAND);
            if (this.alienEntity.isWithinMeleeAttackRange(this.alienEntity.getTarget())) {
                this.alienEntity.doHurtTarget((Entity)this.alienEntity.getTarget());
            } else {
                this.alienEntity.shootAcid(this.alienEntity.getTarget(), (LivingEntity)this.alienEntity);
            }
            this.ranAttackAnimation = false;
        }
    }

    @Override
    protected void checkAndPerformAttack(@NotNull LivingEntity target) {
        if (!this.ranAttackAnimation && this.canPerformAttack(target)) {
            if (this.alienEntity.isWithinMeleeAttackRange(target)) {
                this.alienEntity.animationSelector.select(this.alienEntity);
            } else {
                this.alienEntity.animationDispatcher.sendAcidSpit();
            }
            this.ranAttackAnimation = true;
            this.attackAnimationCooldown.reset();
        }
    }

    protected boolean canPerformAttack(@NotNull LivingEntity entity) {
        return this.isTimeToAttack() && this.alienEntity.getSensing().hasLineOfSight((Entity)entity);
    }
}

