/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.movement;

import java.util.ArrayList;
import java.util.EnumSet;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DodgeProjectilesGoal
extends Goal {
    protected final AlienEntity alienEntity;
    private static final double dodgeChance = 0.15;
    private Vec3 projectileMotionDirection;
    private int giveUpDelay;
    private int dodgeDelay;

    public DodgeProjectilesGoal(AlienEntity alienEntity) {
        this.alienEntity = alienEntity;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP));
    }

    public boolean canUse() {
        return this.dodgeDelay-- <= 0 && this.projectileMotionDirection != null && this.giveUpDelay-- > 0 && this.alienEntity.onGround() && !this.alienEntity.isPassenger();
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        if (this.projectileMotionDirection != null) {
            Vec3 selfAxis = new Vec3(0.0, 1.0, 0.0);
            Vec3 dodgeDirection = selfAxis.cross(this.projectileMotionDirection);
            double velocity = 0.8;
            if (this.alienEntity.getRandom().nextBoolean()) {
                velocity = -velocity;
            }
            Vec3 newMovement = new Vec3(dodgeDirection.x * velocity, 0.3, dodgeDirection.z * velocity);
            BlockPos newPos = this.alienEntity.blockPosition().offset((int)newMovement.x, 0, (int)newMovement.z);
            if (this.isDangerousPosition(newPos)) {
                this.alienEntity.setDeltaMovement(newMovement);
            }
            this.setDodgeTarget(null);
            this.dodgeDelay = 40;
        }
    }

    private boolean isDangerousPosition(BlockPos pos) {
        BlockPos belowPos = pos.below();
        return this.alienEntity.level().isEmptyBlock(belowPos) || this.alienEntity.level().getFluidState(belowPos).isEmpty();
    }

    private static void tryDodgeProjectile(PathfinderMob entity, Vec3 projectileDirection, Entity projectile) {
        for (WrappedGoal task : new ArrayList(entity.goalSelector.getAvailableGoals())) {
            Goal goal = task.getGoal();
            if (!(goal instanceof DodgeProjectilesGoal)) continue;
            DodgeProjectilesGoal dodgeGoal = (DodgeProjectilesGoal)goal;
            float distance = entity.distanceTo(projectile);
            double projectileSpeed = projectile.getDeltaMovement().length();
            if (!((double)distance > 6.0) || !((double)distance < 24.0)) continue;
            double dodgeRadius = 1.0;
            double predictedApproach = Math.abs(projectileDirection.length() - dodgeRadius);
            if (!(predictedApproach <= dodgeRadius) && !(projectileSpeed < 2.0)) continue;
            dodgeGoal.setDodgeTarget(projectileDirection);
        }
    }

    public static void doDodgeCheckForProjectile(Entity projectile) {
        ServerLevel level;
        block6: {
            block5: {
                Level level2 = projectile.level();
                if (!(level2 instanceof ServerLevel)) {
                    return;
                }
                level = (ServerLevel)level2;
                if (projectile.onGround()) break block5;
                if (!(projectile instanceof AbstractArrow)) break block6;
                AbstractArrow arrow = (AbstractArrow)projectile;
                if (!arrow.inGround) break block6;
            }
            return;
        }
        float width = projectile.getBbWidth() + 0.3f;
        Vec3 projectileMotion = projectile.getDeltaMovement();
        double vH = Math.sqrt(projectileMotion.x * projectileMotion.x + projectileMotion.z * projectileMotion.z);
        Vec3 projectileDirection = new Vec3(projectileMotion.x / vH, 0.0, projectileMotion.z / vH);
        int rangeVertical = 16;
        int rangeHorizontal = 24;
        for (Entity entity : level.getAllEntities()) {
            double cos;
            double sin;
            double distanceZ;
            double distanceX;
            double distanceH;
            if (!(entity instanceof PathfinderMob)) continue;
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            int distanceY = Math.abs((int)entity.position().y - (int)projectile.position().y);
            if (distanceY > 16 || !((distanceH = Math.sqrt((distanceX = entity.position().x - projectile.position().x) * distanceX + (distanceZ = entity.position().z - projectile.position().z) * distanceZ)) <= 24.0) || !((double)width > distanceH * (sin = Math.sqrt(1.0 - (cos = (projectileDirection.x * distanceX + projectileDirection.z * distanceZ) / distanceH) * cos)))) continue;
            DodgeProjectilesGoal.tryDodgeProjectile(pathfinderMob, projectileDirection, projectile);
        }
    }

    private void setDodgeTarget(@Nullable Vec3 projectileDirection) {
        if (projectileDirection == null) {
            this.projectileMotionDirection = null;
            this.giveUpDelay = 0;
        } else if (this.dodgeDelay <= 0 && this.alienEntity.getRandom().nextDouble() < 0.15) {
            this.projectileMotionDirection = projectileDirection;
            this.giveUpDelay = 10;
        }
    }
}

