/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper;

import mods.cybercat.gigeresque.common.entity.impl.runner.RunnerbursterEntity;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public interface Growable {
    public float getGrowth();

    public void setGrowth(float var1);

    public float getMaxGrowth();

    default public void grow(Entity entity, float amount) {
        this.setGrowth(Math.min(this.getGrowth() + amount, this.getMaxGrowth()));
        if (this.getGrowth() >= this.getMaxGrowth()) {
            this.growUp(entity);
        }
    }

    public LivingEntity growInto();

    default public void growUp(Entity entity) {
        Level world = entity.level();
        if (!world.isClientSide()) {
            LivingEntity newEntity = this.growInto();
            if (newEntity == null) {
                return;
            }
            newEntity.setPos(entity.getX(), entity.getY(), entity.getZ());
            if (newEntity instanceof RunnerbursterEntity) {
                RunnerbursterEntity runnerBurster = (RunnerbursterEntity)newEntity;
                runnerBurster.setBirthStatus(false);
            }
            world.addFreshEntity((Entity)newEntity);
            if (entity.hasCustomName()) {
                newEntity.setCustomName(entity.getCustomName());
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (newEntity instanceof LivingEntity) {
                    LivingEntity newLivingEntity = newEntity;
                    for (MobEffectInstance effect : livingEntity.getActiveEffects()) {
                        newLivingEntity.addEffect(new MobEffectInstance(effect));
                    }
                }
            }
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public float getGrowthNeededUntilGrowUp() {
        return this.getMaxGrowth() - this.getGrowth();
    }

    default public float getGrowthMultiplier() {
        return 1.0f;
    }
}

