/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.status.effect.impl;

import mod.azure.azurelib.core.object.Color;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.impl.neo.NeobursterEntity;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.DamageSourceUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class SporeStatusEffect
extends MobEffect {
    public SporeStatusEffect() {
        super(MobEffectCategory.HARMFUL, Color.BLACK.getColor());
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public static void effectRemoval(LivingEntity entity, MobEffectInstance mobEffectInstance) {
        Mob mob;
        if (Constants.isCreativeSpecPlayer.test((Entity)entity)) {
            return;
        }
        if (entity.level().isClientSide || !(mobEffectInstance.getEffect().value() instanceof SporeStatusEffect)) {
            return;
        }
        if (entity instanceof Mob && (mob = (Mob)entity).isNoAi()) {
            return;
        }
        if (!entity.getType().is(GigTags.NEOHOST)) {
            return;
        }
        NeobursterEntity burster = (NeobursterEntity)GigEntities.NEOBURSTER.get().create(entity.level());
        if (burster != null) {
            SporeStatusEffect.setBursterProperties(entity, (LivingEntity)burster);
            entity.level().addFreshEntity((Entity)burster);
            if (Constants.isNotCreativeSpecPlayer.test((Entity)entity)) {
                DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.CHEST), entity.getRandom(), 5, 10);
            }
            entity.hurt(GigDamageSources.of(entity.level(), GigDamageSources.SPORE), Float.MAX_VALUE);
        }
    }

    private static void setBursterProperties(LivingEntity entity, LivingEntity burster) {
        if (entity.hasCustomName()) {
            burster.setCustomName(entity.getCustomName());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = entity;
            for (MobEffectInstance effect : livingEntity.getActiveEffects()) {
                if (effect.is(GigStatusEffects.IMPREGNATION)) continue;
                burster.addEffect(new MobEffectInstance(effect));
            }
        }
        burster.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 10), (Entity)burster);
        burster.setPos(entity.getX(), entity.getY(), entity.getZ());
    }

    private static void spawnEffects(Level world, LivingEntity entity) {
        if (!world.isClientSide()) {
            for (int i = 0; i < 2; ++i) {
                ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.POOF, entity.getX() + 0.5, entity.getY(), entity.getZ() + 0.5, 1, entity.getRandom().nextGaussian() * 0.02, entity.getRandom().nextGaussian() * 0.02, entity.getRandom().nextGaussian() * 0.02, (double)0.15f);
            }
        }
    }
}

