/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.util;

import java.util.Objects;
import java.util.function.BiPredicate;
import mod.azure.azurelib.sblforked.util.RandomUtil;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.impl.classic.ChestbursterEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.entity.impl.runner.RunnerbursterEntity;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record GigEntityUtils() {
    public static final BiPredicate<AlienEntity, LivingEntity> TARGET_PREDICATE = (xenomorph, potentialTarget) -> {
        if (xenomorph == null || potentialTarget == null) {
            return false;
        }
        if (xenomorph.level() != potentialTarget.level()) {
            return false;
        }
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(potentialTarget)) {
            return false;
        }
        if (potentialTarget.hasEffect(GigStatusEffects.IMPREGNATION)) {
            return false;
        }
        if (xenomorph.isVehicle()) {
            return false;
        }
        if (xenomorph.isAlliedTo((Entity)potentialTarget)) {
            return false;
        }
        if (!potentialTarget.getType().is(GigTags.ALL_HOSTS)) {
            return false;
        }
        if (potentialTarget.getType().is(EntityTypeTags.UNDEAD)) {
            return false;
        }
        if (potentialTarget.getInBlockState().getBlock() == GigBlocks.NEST_RESIN_WEB_CROSS) {
            return false;
        }
        if (potentialTarget.getType() == EntityType.ARMOR_STAND || potentialTarget.getType() == EntityType.WARDEN || potentialTarget instanceof Bat) {
            return false;
        }
        if (GigEntityUtils.isFacehuggerAttached((Entity)potentialTarget)) {
            return false;
        }
        if (potentialTarget.isInvulnerable() || potentialTarget.isDeadOrDying()) {
            return false;
        }
        if (!xenomorph.level().getWorldBorder().isWithinBounds(potentialTarget.getBoundingBox())) {
            return false;
        }
        if (potentialTarget.getVehicle() != null) {
            if (potentialTarget.getVehicle().getSelfAndPassengers().anyMatch(AlienEntity.class::isInstance)) {
                return false;
            }
        }
        if (potentialTarget.getType().is(GigTags.GIG_ALIENS)) {
            return false;
        }
        if (xenomorph.isAggressive()) {
            return false;
        }
        return xenomorph.level().getBlockState(xenomorph.blockPosition().below()).isCollisionShapeFullBlock((BlockGetter)xenomorph.level(), xenomorph.blockPosition().below());
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFacehuggerAttached(Entity entity) {
        if (entity == null) return false;
        if (!entity.getPassengers().stream().anyMatch(FacehuggerEntity.class::isInstance)) return false;
        return true;
    }

    public static boolean isTargetHostable(Entity target) {
        return target.getType().is(GigTags.CLASSIC_HOSTS) || target.getType().is(GigTags.AQUATIC_HOSTS) || target.getType().is(GigTags.RUNNER_HOSTS);
    }

    public static boolean isTargetGooable(Entity target) {
        return GigEntityUtils.isTargetSmallMutantHost(target) || GigEntityUtils.isTargetLargeMutantHost(target);
    }

    public static boolean isTargetSmallMutantHost(Entity target) {
        return target.getType().is(GigTags.MUTANT_SMALL_HOSTS);
    }

    public static boolean isTargetLargeMutantHost(Entity target) {
        return target.getType().is(GigTags.MUTANT_LARGE_HOSTS);
    }

    public static boolean isTargetDNAImmune(Entity target) {
        return target.getType().is(GigTags.DNAIMMUNE);
    }

    public static boolean convertToNeo(LivingEntity target) {
        return target.getType().is(GigTags.NEOHOST) && target.hasEffect(GigStatusEffects.SPORE);
    }

    public static boolean faceHuggerTest(LivingEntity target) {
        if (target.getType().is(GigTags.GIG_ALIENS)) {
            return false;
        }
        if (target instanceof AmbientCreature) {
            return false;
        }
        if (GigEntityUtils.passengerCheck(target)) {
            return false;
        }
        if (target.hasEffect(GigStatusEffects.IMPREGNATION)) {
            return false;
        }
        if (target.hasEffect(GigStatusEffects.EGGMORPHING)) {
            return false;
        }
        if (GigEntityUtils.isFacehuggerAttached((Entity)target)) {
            return false;
        }
        if (target.getType().is(GigTags.FACEHUGGER_BLACKLIST)) {
            return false;
        }
        return GigEntityUtils.isTargetHostable((Entity)target);
    }

    public static boolean isValidTarget(LivingEntity target) {
        return !target.getType().is(GigTags.GIG_ALIENS) && !target.getType().is(GigTags.XENO_ATTACK_BLACKLIST) && !GigEntityUtils.passengerCheck(target) && !target.hasEffect(GigStatusEffects.IMPREGNATION) && !target.hasEffect(GigStatusEffects.EGGMORPHING) && !GigEntityUtils.isFacehuggerAttached((Entity)target) && target.isAlive() && !target.isInvulnerable() && target.attackable() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(target);
    }

    public static boolean removeFaceHuggerTarget(LivingEntity target) {
        if (target.getType().is(GigTags.GIG_ALIENS)) {
            return false;
        }
        if (GigEntityUtils.passengerCheck(target)) {
            return false;
        }
        if (target.hasEffect(GigStatusEffects.IMPREGNATION)) {
            return false;
        }
        if (target.hasEffect(GigStatusEffects.EGGMORPHING)) {
            return false;
        }
        if (GigEntityUtils.isFacehuggerAttached((Entity)target)) {
            return false;
        }
        if (target.isBaby()) {
            return false;
        }
        if (target.getType().is(GigTags.FACEHUGGER_BLACKLIST)) {
            return false;
        }
        return GigEntityUtils.isTargetHostable((Entity)target) && target.isAlive();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean passengerCheck(LivingEntity target) {
        if (target.getVehicle() == null) return false;
        if (!target.getVehicle().getSelfAndPassengers().anyMatch(AlienEntity.class::isInstance)) return false;
        return true;
    }

    public static void spawnMutant(LivingEntity entity) {
        LivingEntity summon;
        int randomPhase2 = entity.getRandom().nextInt(0, 2);
        if (GigEntityUtils.isTargetSmallMutantHost((Entity)entity)) {
            LivingEntity summon2 = randomPhase2 == 1 ? (LivingEntity)GigEntities.MUTANT_HAMMERPEDE.get().create(entity.level()) : (LivingEntity)GigEntities.MUTANT_POPPER.get().create(entity.level());
            if (summon2 != null) {
                GigEntityUtils.moveToAndSpawn(entity, summon2);
            }
        } else if (GigEntityUtils.isTargetLargeMutantHost((Entity)entity) && (summon = (LivingEntity)GigEntities.MUTANT_STALKER.get().create(entity.level())) != null) {
            GigEntityUtils.moveToAndSpawn(entity, summon);
        }
    }

    public static LivingEntity spawnBurster(LivingEntity entity) {
        ChestbursterEntity defaultBurster = (ChestbursterEntity)GigEntities.CHESTBURSTER.get().create(entity.level());
        if (!entity.hasEffect(GigStatusEffects.SPORE) && !entity.hasEffect(GigStatusEffects.DNA)) {
            if (entity.getType().is(GigTags.RUNNER_HOSTS)) {
                RunnerbursterEntity runnerBurster = (RunnerbursterEntity)GigEntities.RUNNERBURSTER.get().create(entity.level());
                if (runnerBurster != null) {
                    runnerBurster.setHostId("runner");
                    return runnerBurster;
                }
            } else if (entity.getType().is(GigTags.AQUATIC_HOSTS)) {
                return (LivingEntity)GigEntities.AQUATIC_CHESTBURSTER.get().create(entity.level());
            }
        }
        if (GigEntityUtils.convertToNeo(entity)) {
            return (LivingEntity)GigEntities.NEOBURSTER.get().create(entity.level());
        }
        if (entity.hasEffect(GigStatusEffects.DNA)) {
            return (LivingEntity)GigEntities.SPITTER.get().create(entity.level());
        }
        if (entity.getType().is(GigTags.HWG_ENTITIES)) {
            return (LivingEntity)GigEntities.HELL_BURSTER.get().create(entity.level());
        }
        return defaultBurster;
    }

    private static void moveToAndSpawn(@NotNull LivingEntity entity, LivingEntity summon) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = entity;
            for (MobEffectInstance effect : livingEntity.getActiveEffects()) {
                summon.addEffect(new MobEffectInstance(effect));
            }
        }
        summon.setPos(entity.getX(), entity.getY(), entity.getZ());
        GigEntityUtils.spawnEffects(entity.level(), entity);
        entity.level().addFreshEntity((Entity)summon);
    }

    private static void spawnEffects(Level world, LivingEntity entity) {
        if (!world.isClientSide()) {
            for (int i = 0; i < 2; ++i) {
                ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.POOF, entity.getX() + 0.5, entity.getY(), entity.getZ() + 0.5, 1, entity.getRandom().nextGaussian() * 0.02, entity.getRandom().nextGaussian() * 0.02, entity.getRandom().nextGaussian() * 0.02, (double)0.15f);
            }
        }
    }

    public static void placeInNest(@NotNull ServerLevel level, AlienEntity entity, Entity passenger) {
        BlockPos test = RandomUtil.getRandomPositionWithinRange((BlockPos)entity.blockPosition(), (int)3, (int)1, (int)3, (boolean)false, (Level)entity.level());
        for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)test, (BlockPos)test.above(2))) {
            if (!level.getBlockState(test).isAir() || !level.getBlockState(test.below()).isSolid() || !level.getEntitiesOfClass(LivingEntity.class, new AABB(test)).stream().noneMatch(Objects::isNull) || passenger == null) continue;
            passenger.setPos(Vec3.atBottomCenterOf((Vec3i)testPos));
            passenger.removeVehicle();
            passenger.ejectPassengers();
            entity.animationDispatcher.sendLeftClaw();
            level.setBlockAndUpdate(testPos, GigBlocks.NEST_RESIN_WEB_CROSS.get().defaultBlockState());
            level.setBlockAndUpdate(testPos.above(), GigBlocks.NEST_RESIN_WEB_CROSS.get().defaultBlockState());
            entity.ejectPassengers();
            entity.removeVehicle();
        }
    }

    public static boolean inResinEnoughToBeEggmorphed(@NotNull Entity entity) {
        BlockState stateAtEntityPos = entity.level().getBlockState(entity.blockPosition());
        return stateAtEntityPos.is(GigBlocks.NEST_RESIN_WEB_CROSS.get());
    }
}

