/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.mixins.common.entity;

import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"startRiding"}, cancellable=true)
    void gigeresque$boatRidingCancel(Entity entity, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Entity self = (Entity)Constants.self(this);
        if (!self.getType().is(GigTags.GIG_ALIENS)) {
            return;
        }
        if (entity instanceof Boat || entity instanceof Minecart) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    void gigeresque$kickOut(CallbackInfo callbackInfo) {
        Entity self = (Entity)Constants.self(this);
        Level level = self.level();
        if (level.isClientSide) {
            return;
        }
        if (!self.getType().is(GigTags.GIG_ALIENS)) {
            return;
        }
        if (self.getVehicle() instanceof Boat || self.getVehicle() instanceof Minecart) {
            self.stopRiding();
        }
    }
}

