/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.item;

import java.util.List;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_8779;
import org.jetbrains.annotations.NotNull;

public class SurgeryKitItem
extends class_1792 {
    public SurgeryKitItem() {
        super(new class_1792.class_1793().method_7895(CommonMod.config.maxSurgeryKitUses));
    }

    @NotNull
    public class_1269 method_7847(@NotNull class_1799 itemStack, @NotNull class_1657 player, class_1309 livingEntity, @NotNull class_1268 interactionHand) {
        if (livingEntity.method_5685().stream().noneMatch(FacehuggerEntity.class::isInstance) && livingEntity.method_6059(GigStatusEffects.IMPREGNATION)) {
            int currentDurability = itemStack.method_7919();
            int maxDurability = itemStack.method_7936();
            double killChance = this.calculateKillChance(currentDurability, maxDurability);
            this.tryRemoveParasite(itemStack, livingEntity);
            player.method_7357().method_7906((class_1792)this, CommonMod.config.surgeryKitCooldownTicks);
            itemStack.method_7970(1, (class_1309)player, livingEntity.method_32326(itemStack));
            if (player.method_6059(GigStatusEffects.IMPREGNATION)) {
                player.method_6016(GigStatusEffects.IMPREGNATION);
            }
            if (currentDurability < maxDurability && (double)livingEntity.method_59922().method_43051(0, 100) < killChance) {
                livingEntity.method_5643(GigDamageSources.of(livingEntity.method_37908(), GigDamageSources.FAILED_SURGERY), Float.MAX_VALUE);
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_8779 advancement = serverPlayer.field_13995.method_3851().method_12896(Constants.modResource("surgery_kit"));
                if (advancement != null && !serverPlayer.method_14236().method_12882(advancement).method_740()) {
                    for (String s : serverPlayer.method_14236().method_12882(advancement).method_731()) {
                        serverPlayer.method_14236().method_12878(advancement, s);
                    }
                }
            }
        }
        return super.method_7847(itemStack, player, livingEntity, interactionHand);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, class_1657 user, @NotNull class_1268 hand) {
        if (user.method_5685().stream().noneMatch(FacehuggerEntity.class::isInstance) && user.method_6059(GigStatusEffects.IMPREGNATION)) {
            class_1799 itemStack = user.method_5998(hand);
            int currentDurability = itemStack.method_7919();
            int maxDurability = itemStack.method_7936();
            double killChance = this.calculateKillChance(currentDurability, maxDurability);
            this.tryRemoveParasite(user.method_5998(hand), (class_1309)user);
            if (user.method_6059(GigStatusEffects.IMPREGNATION)) {
                user.method_6016(GigStatusEffects.IMPREGNATION);
            }
            if (currentDurability < maxDurability && (double)user.method_59922().method_43051(0, 100) < killChance) {
                user.method_5643(GigDamageSources.of(user.method_37908(), GigDamageSources.FAILED_SURGERY), Float.MAX_VALUE);
            }
            if (user instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)user;
                class_8779 advancement = serverPlayer.field_13995.method_3851().method_12896(Constants.modResource("surgery_kit"));
                if (advancement != null && !serverPlayer.method_14236().method_12882(advancement).method_740()) {
                    for (String s : serverPlayer.method_14236().method_12882(advancement).method_731()) {
                        serverPlayer.method_14236().method_12878(advancement, s);
                    }
                }
            }
        }
        return super.method_7836(world, user, hand);
    }

    private double calculateKillChance(int currentDurability, int maxDurability) {
        int durabilityLost = maxDurability - currentDurability;
        return (double)durabilityLost / (double)maxDurability * 0.4;
    }

    private void tryRemoveParasite(class_1799 stack, class_1309 entity) {
        if (entity.method_6059(GigStatusEffects.IMPREGNATION) || entity.method_6059(GigStatusEffects.SPORE) && !entity.method_37908().field_9236) {
            entity.method_6016(class_1294.field_5903);
            entity.method_6016(class_1294.field_5911);
            entity.method_6016(class_1294.field_5901);
            entity.method_6092(new class_1293(GigStatusEffects.TRAUMA, 600, 0, false, false, true));
            class_1309 burster = GigEntityUtils.spawnBurster(entity);
            if (burster != null) {
                SurgeryKitItem.setBursterProperties(entity, burster);
                entity.method_37908().method_8649((class_1297)burster);
                entity.method_37908().method_45445((class_1297)entity, entity.method_24515(), GigSounds.CHESTBURSTING.get(), class_3419.field_15254, 2.0f, 1.0f);
            }
            if (entity instanceof class_1657) {
                class_1657 playerentity = (class_1657)entity;
                playerentity.method_7357().method_7906((class_1792)this, CommonMod.config.surgeryKitCooldownTicks);
                stack.method_7970(1, (class_1309)playerentity, playerentity.method_32326(stack));
            }
            entity.method_6016(GigStatusEffects.IMPREGNATION);
        }
    }

    private static void setBursterProperties(class_1309 entity, class_1309 burster) {
        if (entity.method_16914()) {
            burster.method_5665(entity.method_5797());
        }
        burster.method_37222(new class_1293(class_1294.field_5909, 60, 10), (class_1297)burster);
        burster.method_5725(entity.method_24515(), entity.method_36454(), entity.method_36455());
    }

    public void method_7851(@NotNull class_1799 stack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 tooltipFlag) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.gigeresque.surgery_kit.tooltip1").method_27692(class_124.field_1065).method_27692(class_124.field_1056));
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.gigeresque.surgery_kit.tooltip2").method_27692(class_124.field_1060).method_27692(class_124.field_1056));
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
    }
}

