/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.feature;

import java.util.UUID;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.layer.AzRenderLayer;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ClassicAgingAzLayer<T extends AlienEntity>
implements AzRenderLayer<UUID, T> {
    private ResourceLocation textureLocation;

    public ClassicAgingAzLayer(ResourceLocation textureLocation) {
        this.textureLocation = textureLocation;
    }

    public void preRender(AzRendererPipelineContext<UUID, T> context) {
    }

    public void render(AzRendererPipelineContext<UUID, T> context) {
        AlienEntity animatable = (AlienEntity)context.animatable();
        AzRendererPipeline renderPipeline = context.rendererPipeline();
        RenderType rendertype = RenderType.entityTranslucentCull((ResourceLocation)this.textureLocation);
        if (animatable.getGrowth() < animatable.getMaxGrowth() && animatable.isAlive()) {
            context.setRenderType(rendertype);
            context.setVertexConsumer(context.multiBufferSource().getBuffer(rendertype));
            float progress = (animatable.getMaxGrowth() - animatable.getGrowth()) / animatable.getMaxGrowth();
            int alpha = (int)(progress * 255.0f) << 24;
            int color = context.renderColor() & 0xFFFFFF | alpha;
            context.setRenderColor(color);
            renderPipeline.reRender(context);
        }
    }

    public void renderForBone(AzRendererPipelineContext<UUID, T> context, AzBone bone) {
    }
}

