/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.feature;

import java.util.UUID;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.layer.AzRenderLayer;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.client.entity.render.feature.EggmorphFeatureRenderer;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EggmorphAzLayer<T extends Entity>
implements AzRenderLayer<UUID, T> {
    private int fovEggticker = 0;

    public void preRender(AzRendererPipelineContext<UUID, T> context) {
    }

    public void render(AzRendererPipelineContext<UUID, T> context) {
        LivingEntity livingEntity;
        Entity animatable = (Entity)context.animatable();
        AzRendererPipeline renderPipeline = context.rendererPipeline();
        ResourceLocation textureLocation = renderPipeline.config().textureLocation(context.currentEntity(), (Object)animatable);
        RenderType renderLayer = EggmorphFeatureRenderer.getEggmorphLayerTexture((ResourceLocation)textureLocation).renderLayer;
        if (animatable instanceof LivingEntity && (livingEntity = (LivingEntity)animatable).getInBlockState().is(GigTags.NEST_CROSS_BLOCKS)) {
            ++this.fovEggticker;
            float progress = (float)this.fovEggticker / CommonMod.config.getEggmorphTickTimer();
            context.setVertexConsumer(context.multiBufferSource().getBuffer(renderLayer));
            int alpha = (int)(progress * 255.0f) << 24;
            int color = context.renderColor() & 0xFFFFFF | alpha;
            context.setRenderColor(color);
            renderPipeline.reRender(context);
        }
    }

    public void renderForBone(AzRendererPipelineContext<UUID, T> context, AzBone bone) {
    }
}

