/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.rom;

import mod.azure.azurelib.common.render.entity.AzEntityRenderer;
import mod.azure.azurelib.common.render.entity.AzEntityRendererConfig;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.entity.model.EntityModels;
import mods.cybercat.gigeresque.client.entity.render.feature.ClassicAgingAzLayer;
import mods.cybercat.gigeresque.client.entity.texture.EntityTextures;
import mods.cybercat.gigeresque.common.entity.animators.rom.RomAlienAnimator;
import mods.cybercat.gigeresque.common.entity.helper.managers.animations.rom.RomAlienAnimManager;
import mods.cybercat.gigeresque.common.entity.impl.rom.RomAlienEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class RomAlienRenderer
extends AzEntityRenderer<RomAlienEntity> {
    private static final ResourceLocation MODEL = Constants.modResource("geo/entity/rom_alien/rom_alien.geo.json");

    protected RomAlienRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder(animatable -> EntityModels.ROM_ALIEN, animatable -> {
            float progress = Math.max(0.0f, Math.min(1.0f - animatable.getGrowth() / animatable.getMaxGrowth(), 1.0f));
            if (animatable.stasisManager.isStasis()) {
                return EntityTextures.ROM_ALIEN_STASIS;
            }
            if (progress > 0.0f) {
                return EntityTextures.ROM_ALIEN_YOUNG;
            }
            return EntityTextures.ROM_ALIEN;
        }).setAnimatorProvider(RomAlienAnimator::new).setRenderEntry(renderEntry -> {
            RomAlienAnimManager.handleAnimations((RomAlienEntity)renderEntry.animatable());
            return renderEntry;
        }).setDeathMaxRotation(0.0f).setShadowRadius(0.5f).addRenderLayer(new ClassicAgingAzLayer(EntityTextures.ROM_ALIEN_YOUNG)).setScale(romAlienEntity -> {
            float scaleFactor = 0.8f + romAlienEntity.getGrowth() / romAlienEntity.getMaxGrowth() / 5.0f;
            return Float.valueOf(Math.min(scaleFactor, 1.0f));
        }).build(), context);
    }
}

