/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GooParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;
    private boolean reachedGround;

    public GooParticle(ClientLevel clientWorld, double d, double e, double f, double g, double h, double i, SpriteSet spriteProvider) {
        super(clientWorld, d, e, f);
        this.xd = g;
        this.yd = h;
        this.zd = i;
        this.setColor(0.0f, 0.0f, 0.0f);
        this.quadSize *= 0.75f;
        this.lifetime = (int)(20.0 / ((double)this.random.nextFloat() * 0.8 + 0.2));
        this.reachedGround = false;
        this.hasPhysics = false;
        this.spriteProvider = spriteProvider;
        this.setSpriteFromAge(spriteProvider);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.spriteProvider);
            if (this.onGround) {
                this.yd = 0.0;
                this.reachedGround = true;
            }
            if (this.reachedGround) {
                this.yd += 0.002;
            }
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float tickDelta) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + tickDelta) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }
}

