/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.particle.GigParticles;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.NotNull;

public class GigSlabBlock
extends SlabBlock {
    public GigSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
        SlabType slabtype = (SlabType)state.getValue((Property)TYPE);
        double startingY = switch (slabtype) {
            case SlabType.DOUBLE, SlabType.TOP -> 1.1;
            default -> 0.55;
        };
        double offsetX = random.nextDouble() - 0.5;
        double offsetY = startingY + random.nextDouble() * 1.3;
        double offsetZ = random.nextDouble() - 0.5;
        if ((level.getBlockState(pos.above()).isAir() || level.getBlockState(pos.above()).is(GigTags.ALLOW_MIST_BLOCKS)) && pos.getY() <= -50 && Constants.particleCount < 1500) {
            level.addParticle((ParticleOptions)GigParticles.MIST.get(), (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 0.0, 0.002, 0.0);
        }
    }
}

