/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block.entity;

import java.util.Objects;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.block.entity.SporeEggDispatcher;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class SporeBlockEntity
extends BlockEntity {
    public static SporeEggDispatcher animationDispatcher;

    public SporeBlockEntity(BlockPos pos, BlockState state) {
        super(GigEntities.SPORE_ENTITY.get(), pos, state);
        animationDispatcher = new SporeEggDispatcher(this);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, SporeBlockEntity blockEntity) {
        if (blockEntity.level != null && blockEntity.level.getGameTime() % 20L == 0L) {
            if (world.isClientSide()) {
                for (int k = 0; k < 4; ++k) {
                    world.addParticle((ParticleOptions)ParticleTypes.ASH, (double)pos.getX() + world.getRandom().nextDouble(), (double)pos.getY() + 0.5 * world.getRandom().nextDouble(), (double)pos.getZ() + world.getRandom().nextDouble(), (world.getRandom().nextDouble() - 0.5) * 2.0, -world.getRandom().nextDouble(), (world.getRandom().nextDouble() - 0.5) * 2.0);
                }
            }
            if (!blockEntity.level.isClientSide) {
                Objects.requireNonNull(blockEntity.getLevel()).getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(3.0, 3.0, 3.0)).forEach(e -> {
                    if (e.getType().is(GigTags.NEOHOST) && !e.hasEffect(GigStatusEffects.SPORE) && (Constants.notPlayer.test((Entity)e) || Constants.isNotCreativeSpecPlayer.test((Entity)e))) {
                        blockEntity.particleCloud((LivingEntity)e);
                    }
                });
            }
        }
    }

    public void particleCloud(LivingEntity entity) {
        AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ());
        areaEffectCloudEntity.setRadius(3.0f);
        areaEffectCloudEntity.setDuration(3);
        areaEffectCloudEntity.setRadiusPerTick(-areaEffectCloudEntity.getRadius() / (float)areaEffectCloudEntity.getDuration());
        areaEffectCloudEntity.setParticle((ParticleOptions)ParticleTypes.ASH);
        if (!entity.hasEffect(GigStatusEffects.SPORE)) {
            areaEffectCloudEntity.addEffect(new MobEffectInstance(GigStatusEffects.SPORE, CommonMod.config.alienblockConfigs.sporeTickTimer, 0));
        }
        this.level.addFreshEntity((Entity)areaEffectCloudEntity);
    }
}

