/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block.petrifiedblocks;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.block.petrifiedblocks.entity.PetrifiedOjbectEntity;
import mods.cybercat.gigeresque.common.block.storage.StorageProperties;
import mods.cybercat.gigeresque.common.block.storage.StorageStates;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PetrifiedObjectBlock
extends BaseEntityBlock {
    public static final IntegerProperty HATCH = BlockStateProperties.AGE_25;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<StorageStates> STORAGE_STATE = StorageProperties.STORAGE_STATE;
    public static final MapCodec<PetrifiedObjectBlock> CODEC = PetrifiedObjectBlock.simpleCodec(PetrifiedObjectBlock::new);

    public PetrifiedObjectBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCH, (Comparable)Integer.valueOf(0))).setValue(STORAGE_STATE, (Comparable)((Object)StorageStates.CLOSED))).setValue((Property)FACING, (Comparable)Direction.SOUTH));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide()) {
            level.playSound(null, pos, SoundEvents.STONE_HIT, SoundSource.BLOCKS, 0.3f, 0.9f + level.getRandom().nextFloat() * 0.2f);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void stepOn(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        if (level.isClientSide()) {
            level.playSound(null, pos, SoundEvents.STONE_STEP, SoundSource.BLOCKS, 0.3f, 0.9f + level.getRandom().nextFloat() * 0.2f);
        }
        super.stepOn(level, pos, state, entity);
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack itemStack) {
        if (state.getValue(STORAGE_STATE) == StorageStates.OPENED) {
            player.awardStat(Stats.BLOCK_MINED.get((Object)this));
            player.causeFoodExhaustion(0.005f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int radius = 0;
                for (int i = 0; i < 2; ++i) {
                    int x = serverLevel.getRandom().nextInt(2) - radius;
                    int z = serverLevel.getRandom().nextInt(2) - radius;
                    Entity acidEntity = GigEntities.ACID.get().create((Level)serverLevel);
                    assert (acidEntity != null);
                    acidEntity.moveTo(pos.offset(x, 0, z), 0.0f, 0.0f);
                    serverLevel.addFreshEntity(acidEntity);
                }
            }
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        } else {
            PetrifiedObjectBlock.dropResources(state, level, pos);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    public static void dropResources(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double d = (double)EntityType.ITEM.getHeight() / 2.0;
            double x = (double)pos.getX() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
            double y = (double)pos.getY() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25) - d;
            double z = (double)pos.getZ() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, GigBlocks.PETRIFIED_OBJECT_BLOCK.get().asItem().getDefaultInstance());
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
            state.spawnAfterBreak(serverLevel, pos, ItemStack.EMPTY, false);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HATCH, STORAGE_STATE, FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return GigEntities.PETRIFIED_OBJECT.get().create(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Stream.of(Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)2.0, (double)12.5), Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.box((double)4.0, (double)10.0, (double)3.5, (double)12.0, (double)12.0, (double)12.5), Block.box((double)5.0, (double)11.5, (double)4.5, (double)11.0, (double)13.5, (double)11.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return PetrifiedObjectBlock.createTickerHelper(type, GigEntities.PETRIFIED_OBJECT.get(), PetrifiedOjbectEntity::tick);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace() == Direction.UP || context.getClickedFace() == Direction.DOWN) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite().getOpposite());
    }
}

