/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block.petrifiedblocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.block.petrifiedblocks.entity.PetrifiedStatueEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PetrifiedStatueBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty UNSAFE = BooleanProperty.create((String)"unsafe");
    private static final VoxelShape OUTLINE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    BlockPos[] blockPoss;
    public static final MapCodec<PetrifiedStatueBlock> CODEC = PetrifiedStatueBlock.simpleCodec(PetrifiedStatueBlock::new);

    public PetrifiedStatueBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)UNSAFE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, UNSAFE});
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return GigEntities.PETRIFIED_STATUE.get().create(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return OUTLINE_SHAPE;
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level world, @NotNull BlockPos pos, BlockState state, @NotNull Player player) {
        BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.relative((Direction)state.getValue((Property)FACING), 1).above(2)).forEach(testPos -> {
            if (!testPos.equals((Object)pos)) {
                world.destroyBlock(testPos, false);
            }
        });
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, BlockState state, LivingEntity placer, @NotNull ItemStack itemStack) {
        BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.relative((Direction)state.getValue((Property)FACING), 1).above(2)).forEach(testPos -> {
            if (!testPos.equals((Object)pos)) {
                world.setBlock(testPos, GigBlocks.PETRIFIED_STATUE_BLOCK_INVIS.get().defaultBlockState(), 3);
            }
        });
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.relative((Direction)state.getValue((Property)FACING), 1).above(2))) {
            if (testPos.equals((Object)pos) || world.getBlockState(testPos).isAir()) continue;
            return false;
        }
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"block.gigeresque.unfinished.tooltip").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return PetrifiedStatueBlock.createTickerHelper(type, GigEntities.PETRIFIED_STATUE.get(), PetrifiedStatueEntity::tick);
    }
}

