/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.function.BiConsumer;
import mod.azure.azurelib.common.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.AzureTicker;
import mods.cybercat.gigeresque.common.entity.helper.AzureVibrationUser;
import mods.cybercat.gigeresque.common.entity.helper.GigCommonMethods;
import mods.cybercat.gigeresque.common.entity.helper.Growable;
import mods.cybercat.gigeresque.common.entity.helper.managers.AlienNavigationManager;
import mods.cybercat.gigeresque.common.entity.helper.managers.CrawlingManager;
import mods.cybercat.gigeresque.common.entity.helper.managers.SearchingManager;
import mods.cybercat.gigeresque.common.entity.helper.managers.StasisManager;
import mods.cybercat.gigeresque.common.entity.impl.projectile.AcidSpitProjectile;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.DamageSourceUtils;
import mods.cybercat.gigeresque.interfacing.AbstractAlien;
import mods.cybercat.gigeresque.interfacing.AnimationSelector;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AlienEntity
extends Monster
implements Enemy,
VibrationSystem,
Growable,
AbstractAlien {
    public static final EntityDataAccessor<BlockPos> HOME_BLOCKPOS = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Boolean> FLEEING_FIRE = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> IS_STASIS = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_CRAWLING = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> WAKING_UP = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> CLIENT_ANGER_LEVEL = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> GROWTH = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Boolean> IS_HISSING = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> IS_SEARCHING = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> IS_EXECUTION = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> IS_HEADBITE = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> STASIS_TICK = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> IS_BIRTHED = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> CARRYING_DAMAGE = SynchedEntityData.defineId(AlienEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected int delayBeforeEating = 0;
    protected boolean triggeredAttackAnimation = false;
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener;
    public int wakeupCounter = 0;
    public boolean inTwoBlockSpace = false;
    public float growthCounter = 0.0f;
    protected VibrationSystem.User vibrationUser;
    private VibrationSystem.Data vibrationData;
    public BlockPos savedNestWebCross;
    public SearchingManager searchingManager;
    public AnimationDispatcher animationDispatcher;
    public MoveAnalysis moveAnalysis;
    public final CrawlingManager crawlingManager;
    public final StasisManager stasisManager;
    public AnimationSelector<AlienEntity> animationSelector;
    private final AlienNavigationManager navigationManager;
    private int healCounter;

    protected AlienEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
        this.crawlingManager = new CrawlingManager((PathfinderMob)this, IS_CRAWLING);
        this.searchingManager = new SearchingManager(this, IS_SEARCHING);
        this.stasisManager = new StasisManager(this, IS_STASIS, STASIS_TICK);
        this.vibrationUser = new AzureVibrationUser(this, 1.0f);
        this.vibrationData = new VibrationSystem.Data();
        this.dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
        this.navigationManager = new AlienNavigationManager(this, this.moveControl);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        return level.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || AlienEntity.isDarkEnoughToSpawn(level, pos, random)) && AlienEntity.checkMobSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, @NotNull BlockPos pos, RandomSource random) {
        if (level.getBrightness(LightLayer.SKY, pos) > random.nextInt(32)) {
            return false;
        }
        DimensionType dimensiontype = level.dimensionType();
        int i = dimensiontype.monsterSpawnBlockLightLimit();
        if (i < 15 && level.getBrightness(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = level.getLevel().isThundering() ? level.getMaxLocalRawBrightness(pos, 10) : level.getMaxLocalRawBrightness(pos);
        return j <= dimensiontype.monsterSpawnLightTest().sample(random);
    }

    public float maxUpStep() {
        return 1.5f;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 150) {
            this.remove(Entity.RemovalReason.KILLED);
            super.tickDeath();
            this.dropExperience((Entity)this);
        }
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    @Override
    public int getAcidDiameter() {
        return 0;
    }

    @Override
    public boolean isFleeing() {
        return (Boolean)this.entityData.get(FLEEING_FIRE);
    }

    @Override
    public void setFleeingStatus(boolean fleeing) {
        this.entityData.set(FLEEING_FIRE, (Object)fleeing);
    }

    @Override
    public void setWakingUpStatus(boolean passout) {
        this.entityData.set(WAKING_UP, (Object)passout);
    }

    @Override
    public boolean isWakingUp() {
        return (Boolean)this.entityData.get(WAKING_UP);
    }

    @Override
    public boolean isExecuting() {
        return (Boolean)this.entityData.get(IS_EXECUTION);
    }

    @Override
    public void setIsExecuting(boolean isExecuting) {
        this.entityData.set(IS_EXECUTION, (Object)isExecuting);
    }

    @Override
    public boolean isBiting() {
        return (Boolean)this.entityData.get(IS_HEADBITE);
    }

    @Override
    public void setIsBiting(boolean isBiting) {
        this.entityData.set(IS_HEADBITE, (Object)isBiting);
    }

    @Override
    public boolean isHissing() {
        return (Boolean)this.entityData.get(IS_HISSING);
    }

    @Override
    public void setIsHissing(boolean isHissing) {
        this.entityData.set(IS_HISSING, (Object)isHissing);
    }

    public boolean isBirthed() {
        return (Boolean)this.entityData.get(IS_BIRTHED);
    }

    public void setBirthStatus(boolean birth) {
        this.entityData.set(IS_BIRTHED, (Object)birth);
    }

    @Override
    public float getGrowth() {
        return ((Float)this.entityData.get(GROWTH)).floatValue();
    }

    @Override
    public void setGrowth(float growth) {
        this.entityData.set(GROWTH, (Object)Float.valueOf(growth));
    }

    public float getCarryDamage() {
        return ((Float)this.entityData.get(CARRYING_DAMAGE)).floatValue();
    }

    public void setCarryDamage(float damage) {
        this.entityData.set(CARRYING_DAMAGE, (Object)Float.valueOf(damage));
    }

    public BlockPos getHomeBlock() {
        return (BlockPos)this.entityData.get(HOME_BLOCKPOS);
    }

    public void setHomeBlock(BlockPos pos) {
        this.entityData.set(HOME_BLOCKPOS, (Object)pos);
    }

    public boolean hasHomeBlock() {
        return !this.getHomeBlock().equals((Object)BlockPos.ZERO);
    }

    public void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLEEING_FIRE, (Object)false);
        builder.define(STATE, (Object)0);
        builder.define(CLIENT_ANGER_LEVEL, (Object)0);
        builder.define(GROWTH, (Object)Float.valueOf(0.0f));
        builder.define(WAKING_UP, (Object)false);
        builder.define(IS_HISSING, (Object)false);
        builder.define(IS_EXECUTION, (Object)false);
        builder.define(IS_HEADBITE, (Object)false);
        builder.define(IS_BIRTHED, (Object)false);
        builder.define(IS_STASIS, (Object)false);
        builder.define(IS_SEARCHING, (Object)false);
        builder.define(IS_CRAWLING, (Object)false);
        builder.define(STASIS_TICK, (Object)0);
        builder.define(HOME_BLOCKPOS, (Object)BlockPos.ZERO);
        builder.define(CARRYING_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)CommonMod.LOGGER).error(arg_0)).ifPresent(tag -> compound.put("listener", tag));
        compound.putFloat("growth", this.getGrowth());
        compound.putBoolean("wakingup", this.isWakingUp());
        compound.putBoolean("isHissing", this.isHissing());
        compound.putBoolean("isExecuting", this.isExecuting());
        compound.putBoolean("isHeadBite", this.isBiting());
        compound.putBoolean("is_birthed", this.isBirthed());
        compound.putFloat("carry_damage", this.getCarryDamage());
        BlockPos homeBlock = this.getHomeBlock();
        if (homeBlock != null) {
            NbtUtils.writeBlockPos((BlockPos)homeBlock);
        }
        this.stasisManager.save(compound);
        this.searchingManager.save(compound);
        this.crawlingManager.save(compound);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.crawlingManager.load(compound);
        this.searchingManager.load(compound);
        this.stasisManager.load(compound);
        if (compound.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)compound.getCompound("listener"))).resultOrPartial(arg_0 -> ((Logger)CommonMod.LOGGER).error(arg_0)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
        this.setGrowth(compound.getFloat("growth"));
        this.setIsHissing(compound.getBoolean("isHissing"));
        this.setIsBiting(compound.getBoolean("isHeadBite"));
        this.setIsExecuting(compound.getBoolean("isExecuting"));
        this.setIsExecuting(compound.getBoolean("isHeadBite"));
        this.setWakingUpStatus(compound.getBoolean("wakingup"));
        this.setCarryDamage(compound.getFloat("carry_damage"));
        if (compound.contains("is_birthed")) {
            this.setBirthStatus(compound.getBoolean("is_birthed"));
        }
        if (compound.contains("homeBlock")) {
            this.setHomeBlock(NbtUtils.readBlockPos((CompoundTag)compound, (String)"homeBlock").orElse(BlockPos.ZERO));
        }
    }

    protected boolean canRide(@NotNull Entity vehicle) {
        return false;
    }

    public int calculateFallDamage(float fallDistance, float damageMultiplier) {
        if (fallDistance <= 15.0f) {
            return 0;
        }
        return super.calculateFallDamage(fallDistance, damageMultiplier);
    }

    public int getMaxFallDistance() {
        return 9;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void tick() {
        super.tick();
        this.setAirSupply(this.getMaxAirSupply());
        this.searchingManager.tick();
        this.stasisManager.tick();
        this.setAirSupply(this.getMaxAirSupply());
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isAlive()) {
                if (CommonMod.config.generalConfigs.enablePeacefulModeRemoval && this.level().getDifficulty() == Difficulty.PEACEFUL) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
                if (this.getGrowth() <= this.getMaxGrowth() && this.tickCount % 20 == 0) {
                    if (CommonMod.config.generalConfigs.enableLogging && this.getGrowth() > 0.0f) {
                        CommonMod.LOGGER.warn("Current Growth: {} of {} located at {}", (Object)Float.valueOf(this.getGrowth()), (Object)this.getDisplayName().getString(), (Object)this.blockPosition());
                    }
                    this.growthCounter += 1.0f;
                    this.setGrowth((this.getGrowth() + 1.0f) * this.getGrowthMultiplier());
                } else if (this.getGrowth() >= this.getMaxGrowth()) {
                    this.growUp((Entity)this);
                }
                if (!this.isVehicle()) {
                    this.setCarryDamage(0.0f);
                }
                if (this.getHealth() != this.getMaxHealth() && this.getTarget() == null && this.tickCount % 20 == 0) {
                    ++this.healCounter;
                    if (CommonMod.config.generalConfigs.enableLogging) {
                        CommonMod.LOGGER.warn("Current Health: {} and Max Health: {} of {}", (Object)Float.valueOf(this.getHealth()), (Object)Float.valueOf(this.getMaxHealth()), (Object)this.getDisplayName().getString());
                    }
                    if (this.healCounter >= 20 && (float)this.healCounter > this.lastHurt) {
                        float healAmount = 3.5833f;
                        if (this.level().getBlockStatesIfLoaded(this.getBoundingBox().inflate(5.0)).anyMatch(state -> state.is(GigTags.NEST_BLOCKS))) {
                            healAmount *= 1.5f;
                        }
                        if (CommonMod.config.generalConfigs.enableLogging) {
                            CommonMod.LOGGER.warn("Now healing for {}", (Object)Float.valueOf(healAmount));
                        }
                        this.heal(healAmount);
                        this.healCounter = 0;
                        this.lastHurt = 0.0f;
                    }
                }
                if (this.isExecuting()) {
                    this.navigation.stop();
                }
                AzureTicker.tick((Level)serverLevel, this.vibrationData, this.vibrationUser);
            }
        }
        if (this.tickCount % 10 == 0) {
            this.refreshDimensions();
        }
    }

    protected void jumpInLiquid(@NotNull TagKey<Fluid> fluid) {
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    public void checkDespawn() {
    }

    public void die(@NotNull DamageSource source) {
        boolean damageCheck;
        if (DamageSourceUtils.isDamageSourceNotPuncturing(source, this.damageSources()) || source == this.damageSources().genericKill()) {
            super.die(source);
            return;
        }
        boolean bl = damageCheck = !this.level().isClientSide && source != this.damageSources().genericKill() || source != this.damageSources().generic();
        if (damageCheck && !this.getType().is(GigTags.NO_ACID_BLOOD)) {
            if (this.getAcidDiameter() == 1) {
                GigCommonMethods.generateAcidPool((LivingEntity)this, this.blockPosition(), 0, 0);
            } else {
                int radius = (this.getAcidDiameter() - 1) / 2;
                for (int i = 0; i < this.getAcidDiameter(); ++i) {
                    int x = this.level().getRandom().nextInt(this.getAcidDiameter()) - radius;
                    int z = this.level().getRandom().nextInt(this.getAcidDiameter()) - radius;
                    if (source == this.damageSources().genericKill() && source == this.damageSources().generic()) continue;
                    GigCommonMethods.generateAcidPool((LivingEntity)this, this.blockPosition(), x, z);
                }
            }
        }
        super.die(source);
    }

    public void updateDynamicGameEventListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> biConsumer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            biConsumer.accept(this.dynamicGameEventListener, serverLevel);
        }
    }

    public void travel(@NotNull Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isUnderWater()) {
            this.moveRelative(0.1f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    @NotNull
    public SoundEvent getHurtSound(@NotNull DamageSource source) {
        return GigSounds.ALIEN_HURT.get();
    }

    @NotNull
    public SoundEvent getDeathSound() {
        return GigSounds.ALIEN_DEATH.get();
    }

    @NotNull
    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.DOLPHIN_SPLASH;
    }

    @NotNull
    protected SoundEvent getSwimSound() {
        return SoundEvents.DOLPHIN_SWIM;
    }

    public boolean isPushable() {
        return false;
    }

    public void grabTarget(Entity entity) {
        if (entity == this.getTarget() && !entity.hasPassenger((Entity)this) && entity.getInBlockState().getBlock() != GigBlocks.NEST_RESIN_WEB_CROSS) {
            entity.startRiding((Entity)this, true);
            this.setAggressive(false);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.connection.send((Packet)new ClientboundSetPassengersPacket(entity));
            }
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Entity entity;
        float multiplier = 1.0f;
        if (source == this.damageSources().onFire()) {
            multiplier = 2.0f;
        }
        if (source == this.damageSources().inWall()) {
            return false;
        }
        if (this.isVehicle() && !this.level().isClientSide) {
            this.setCarryDamage(this.getCarryDamage() + amount);
            if (this.getCarryDamage() > 15.0f) {
                this.ejectPassengers();
                this.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 60, 10, false, false));
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 10, false, false));
                GigCommonMethods.setAnimation(this.animationDispatcher::sendUnkidnap);
            }
        }
        if (!this.level().isClientSide && source.getEntity() != null && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            this.brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)attacker);
        }
        if (DamageSourceUtils.isDamageSourceNotPuncturing(source, this.damageSources())) {
            return super.hurt(source, amount);
        }
        if (!this.level().isClientSide && source != this.damageSources().genericKill() && !this.getType().is(GigTags.NO_ACID_BLOOD) && this.isAlive() && amount > 8.0f) {
            if (this.getAcidDiameter() == 1) {
                GigCommonMethods.generateAcidPool((LivingEntity)this, this.blockPosition(), 0, 0);
            } else {
                int radius = (this.getAcidDiameter() - 1) / 2;
                for (int i = 0; i < this.getAcidDiameter(); ++i) {
                    int x = this.level().getRandom().nextInt(this.getAcidDiameter()) - radius;
                    int z = this.level().getRandom().nextInt(this.getAcidDiameter()) - radius;
                    if (source == this.damageSources().genericKill() && source == this.damageSources().generic()) continue;
                    GigCommonMethods.generateAcidPool((LivingEntity)this, this.blockPosition(), x, z);
                }
            }
        }
        if (source != this.damageSources().genericKill()) {
            float safeAmount = Math.max(amount, 1.0f);
            float adjustedAmount = safeAmount > 50.0f ? safeAmount / (float)Math.log10(safeAmount) : safeAmount;
            return super.hurt(source, adjustedAmount);
        }
        return super.hurt(source, amount * multiplier);
    }

    @Override
    public float getMaxGrowth() {
        return 300.0f;
    }

    @Override
    public LivingEntity growInto() {
        return null;
    }

    @NotNull
    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    @NotNull
    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    public void drop(LivingEntity target, ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return;
        }
        double d = target.getEyeY() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(target.level(), target.getX(), d, target.getZ(), itemStack);
        itemEntity.setPickUpDelay(40);
        float g = Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180)));
        float h = Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180)));
        float i = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
        float j = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
        float k = this.random.nextFloat() * ((float)Math.PI * 2);
        float l = 0.02f * this.random.nextFloat();
        itemEntity.setDeltaMovement((double)(-i * h * 0.3f) + Math.cos(k) * (double)l, (double)(-g * 0.3f + 0.010000001f), (double)(j * h * 0.3f) + Math.sin(k) * (double)l);
        target.level().addFreshEntity((Entity)itemEntity);
    }

    public void shootAcid(LivingEntity target, LivingEntity attacker) {
        AcidSpitProjectile acidProjectile;
        if (attacker.hasLineOfSight((Entity)target) && (acidProjectile = (AcidSpitProjectile)GigEntities.ACID_PROJECTILE.get().create(this.level())) != null) {
            Vec3 attackDirection = attacker.getViewVector(1.0f);
            acidProjectile.setPos(attacker.getX() + attackDirection.x * 2.0, attacker.getY(0.5), attacker.getZ() + attackDirection.z * 2.0);
            double dx = target.getX() - acidProjectile.getX();
            double dy = target.getY(0.5) - acidProjectile.getY();
            double dz = target.getZ() - acidProjectile.getZ();
            float velocity = 1.0f;
            float inaccuracy = 0.1f;
            acidProjectile.shoot(dx, dy, dz, velocity, inaccuracy);
            attacker.level().addFreshEntity((Entity)acidProjectile);
        }
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (player.getItemInHand(hand).is(Items.BUCKET) && !player.level().isClientSide()) {
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            player.addEffect(new MobEffectInstance(GigStatusEffects.ACID, 100, 0), (Entity)this);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(Constants.modResource("dontdothat"));
                if (advancement != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                    for (String s : serverPlayer.getAdvancements().getOrStartProgress(advancement).getRemainingCriteria()) {
                        serverPlayer.getAdvancements().award(advancement, s);
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (player.getItemInHand(hand).is(Items.GLASS_BOTTLE) && !player.level().isClientSide()) {
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            player.hurt(GigDamageSources.of(player.level(), GigDamageSources.ACID), CommonMod.config.alienblockConfigs.acidDamage);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(Constants.modResource("dontacidbottle"));
                if (advancement != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                    for (String s : serverPlayer.getAdvancements().getOrStartProgress(advancement).getRemainingCriteria()) {
                        serverPlayer.getAdvancements().award(advancement, s);
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public boolean isWithinMeleeAttackRange(@NotNull LivingEntity entity) {
        if (this.getBoundingBox().inflate(1.25).intersects(entity.getBoundingBox())) {
            return true;
        }
        return super.isWithinMeleeAttackRange(entity);
    }

    public boolean dampensVibrations() {
        return true;
    }

    public boolean onClimbable() {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.position().x, this.position().y + 2.0, this.position().z);
        if (this.level().getBlockState((BlockPos)blockPos).blocksMotion()) {
            this.inTwoBlockSpace = true;
        }
        if (!this.level().getBlockState((BlockPos)blockPos).blocksMotion()) {
            this.inTwoBlockSpace = false;
        }
        return this.inTwoBlockSpace;
    }

    public void setMoveControl(MoveControl moveControl) {
        this.moveControl = moveControl;
    }

    public void setNavigation(PathNavigation navigation) {
        this.navigation = navigation;
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.isUnderWater() && !this.level().getBlockState(this.blockPosition().above()).isAir()) {
                this.navigationManager.switchToWater(this);
                this.setSwimming(true);
            } else {
                this.navigationManager.switchToGround(this);
                this.setSwimming(false);
            }
        }
    }

    protected void runLungeAnimation() {
        this.animationDispatcher.sendLunge();
    }

    protected void checkAndPerformEating(ItemEntity target) {
        if (target == null) {
            return;
        }
        if (this.isBirthed()) {
            return;
        }
        if (this.getGrowth() < 10.0f) {
            return;
        }
        if (this.isWithinEatingRange(target)) {
            this.lookAt((Entity)target, 10.0f, 10.0f);
            if (this.delayBeforeEating > 0) {
                --this.delayBeforeEating;
                if (this.delayBeforeEating == 5 && !this.triggeredAttackAnimation) {
                    this.animationDispatcher.sendChomp();
                    this.triggeredAttackAnimation = true;
                }
            } else {
                float growthValue;
                if (target.getItem().is(GigTags.POTIONS)) {
                    this.playSound(SoundEvents.GLASS_BREAK, 1.0f, 1.0f);
                } else {
                    this.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
                }
                this.swing(InteractionHand.MAIN_HAND);
                if (target.getItem().has(DataComponents.FOOD)) {
                    FoodProperties foodComponent = (FoodProperties)target.getItem().get(DataComponents.FOOD);
                    growthValue = (float)foodComponent.nutrition() * 20.0f;
                    target.getItem().finishUsingItem(this.level(), (LivingEntity)this);
                } else {
                    growthValue = 20.0f;
                    if (target.getItem().is(GigTags.POTIONS)) {
                        target.getItem().finishUsingItem(this.level(), (LivingEntity)this);
                        target.getItem().consume(1, (LivingEntity)this);
                    } else {
                        target.getItem().consume(1, (LivingEntity)this);
                    }
                }
                this.setGrowth(this.getGrowth() + growthValue);
                this.triggeredAttackAnimation = false;
                this.delayBeforeEating = 20;
            }
        } else {
            --this.delayBeforeEating;
            this.triggeredAttackAnimation = false;
        }
    }

    public boolean isWithinEatingRange(@NotNull ItemEntity entity) {
        for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)this.blockPosition().relative(this.getDirection(), 1).above(-1).relative(this.getDirection().getClockWise(), -1), (BlockPos)this.blockPosition().relative(this.getDirection(), 3).above(1).relative(this.getDirection().getClockWise(), 1))) {
            if (!entity.blockPosition().equals((Object)testPos)) continue;
            return true;
        }
        return this.getBoundingBox().intersects(entity.getBoundingBox().inflate(1.5));
    }
}

