/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.nest;

import java.util.EnumSet;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class EggmorphGoal
extends Goal {
    protected final AlienEntity mob;

    public EggmorphGoal(AlienEntity mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.mob.hasHomeBlock() && this.mob.isVehicle();
    }

    public boolean canContinueToUse() {
        return this.mob.hasHomeBlock() && !this.mob.isFleeing() && this.mob.isVehicle() && !this.mob.stasisManager.isStasis();
    }

    public void start() {
    }

    public void stop() {
    }

    public void tick() {
        if (this.mob.hasHomeBlock() && this.isPathfindable(this.mob.getHomeBlock())) {
            BlockPos blockPos = this.mob.getHomeBlock();
            Vec3 centerPos = Vec3.atCenterOf((Vec3i)blockPos);
            this.mob.getNavigation().moveTo(centerPos.x, centerPos.y, centerPos.z, (double)0.8f);
        }
    }

    private boolean isPathfindable(BlockPos blockPos) {
        return this.mob.getNavigation().createPath(blockPos, 0) != null;
    }
}

