/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper;

import mods.cybercat.gigeresque.CommonMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;

public interface AzureTicker {
    public static void tick(Level level, VibrationSystem.Data data, VibrationSystem.User user) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (data.getCurrentVibration() == null) {
            AzureTicker.trySelectAndScheduleVibration(serverLevel, data, user);
        }
        if (data.getCurrentVibration() == null) {
            return;
        }
        boolean travelCheck = data.getTravelTimeInTicks() > 0;
        data.decrementTravelTime();
        if (data.getTravelTimeInTicks() <= 0) {
            travelCheck = AzureTicker.receiveVibration(serverLevel, data, user, data.getCurrentVibration());
        }
        if (travelCheck) {
            user.onDataChanged();
        }
    }

    private static void trySelectAndScheduleVibration(ServerLevel serverLevel, VibrationSystem.Data data, VibrationSystem.User user) {
        data.getSelectionStrategy().chosenCandidate(serverLevel.getGameTime()).ifPresent(vibrationInfo -> {
            data.setCurrentVibration(vibrationInfo);
            Vec3 vec3 = vibrationInfo.pos();
            data.setTravelTimeInTicks(user.calculateTravelTimeInTicks(vibrationInfo.distance()));
            if (CommonMod.config.generalConfigs.enableDevparticles) {
                serverLevel.sendParticles((ParticleOptions)new VibrationParticleOption(user.getPositionSource(), data.getTravelTimeInTicks()), vec3.x, vec3.y, vec3.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            user.onDataChanged();
            data.getSelectionStrategy().startOver();
        });
    }

    private static boolean receiveVibration(ServerLevel serverLevel, VibrationSystem.Data data, VibrationSystem.User user, VibrationInfo vibrationInfo) {
        BlockPos blockPos = BlockPos.containing((Position)vibrationInfo.pos());
        BlockPos blockPos2 = user.getPositionSource().getPosition((Level)serverLevel).map(BlockPos::containing).orElse(blockPos);
        if (user.requiresAdjacentChunksToBeTicking() && !AzureTicker.areAdjacentChunksTicking((Level)serverLevel, blockPos2)) {
            return false;
        }
        user.onReceiveVibration(serverLevel, blockPos, vibrationInfo.gameEvent(), (Entity)vibrationInfo.getEntity(serverLevel).orElse(null), (Entity)vibrationInfo.getProjectileOwner(serverLevel).orElse(null), VibrationSystem.Listener.distanceBetweenInBlocks((BlockPos)blockPos, (BlockPos)blockPos2));
        data.setCurrentVibration(null);
        return true;
    }

    private static boolean areAdjacentChunksTicking(Level level, BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        for (int i = chunkPos.x - 1; i < chunkPos.x + 1; ++i) {
            for (int j = chunkPos.z - 1; j < chunkPos.z + 1; ++j) {
                LevelChunk chunkAccess = level.getChunkSource().getChunkNow(i, j);
                if (chunkAccess != null && level.shouldTickBlocksAt(chunkAccess.getPos().toLong())) continue;
                return false;
            }
        }
        return true;
    }
}

