/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper;

import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.entity.impl.mutant.HammerpedeEntity;
import mods.cybercat.gigeresque.common.entity.impl.mutant.PopperEntity;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzureVibrationUser
implements VibrationSystem.User {
    private final AlienEntity mob;
    private final float moveSpeed;
    private final PositionSource positionSource;

    public AzureVibrationUser(AlienEntity entity, float speed) {
        this.positionSource = new EntityPositionSource((Entity)entity, entity.getEyeHeight());
        this.mob = entity;
        this.moveSpeed = speed;
    }

    public int getListenerRadius() {
        double mobY = this.mob.getY();
        int maxY = 320;
        int minY = -64;
        int maxRadius = CommonMod.config.entityConfigs.xenoMaxSoundRange;
        double factor = Math.clamp((mobY - -64.0) / 384.0, 0.25, 1.0);
        return (int)((double)maxRadius * factor);
    }

    @NotNull
    public PositionSource getPositionSource() {
        return this.positionSource;
    }

    @NotNull
    public TagKey<GameEvent> getListenableEvents() {
        return GigTags.ALIEN_CAN_LISTEN;
    }

    public boolean canTriggerAvoidVibration() {
        return true;
    }

    public boolean isValidVibration(Holder<GameEvent> gameEvent, @NotNull GameEvent.Context context) {
        if (!gameEvent.is(this.getListenableEvents())) {
            return false;
        }
        Entity entity = context.sourceEntity();
        if (entity != null) {
            if (this.mob.isAggressive()) {
                return false;
            }
            if (entity.isSpectator()) {
                return false;
            }
            if (entity.dampensVibrations()) {
                return false;
            }
            if (this.mob.level().getEntitiesOfClass(LivingEntity.class, this.mob.getBoundingBox().inflate(3.0)).stream().anyMatch(target -> !target.getType().is(GigTags.GIG_ALIENS))) {
                return true;
            }
            if (this.mob.level().getEntitiesOfClass(LivingEntity.class, this.mob.getBoundingBox().inflate((double)this.getListenerRadius())).stream().anyMatch(Entity::isSteppingCarefully)) {
                return false;
            }
        }
        if (context.affectedState() != null) {
            return !context.affectedState().is(BlockTags.DAMPENS_VIBRATIONS);
        }
        return true;
    }

    public boolean canReceiveVibration(@NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull Holder<GameEvent> gameEvent, @NotNull GameEvent.Context context) {
        if (this.mob.isNoAi() || this.mob.isDeadOrDying() || !this.mob.level().getWorldBorder().isWithinBounds(blockPos) || this.mob.isRemoved()) {
            return false;
        }
        Entity entity = context.sourceEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return GigEntityUtils.TARGET_PREDICATE.test(this.mob, livingEntity);
        }
        return true;
    }

    public void onReceiveVibration(@NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity entity2, float f) {
        if (this.mob.isDeadOrDying()) {
            return;
        }
        if (this.mob.isVehicle()) {
            return;
        }
        this.doVibrationAction(blockPos, entity2);
    }

    private void doVibrationAction(@NotNull BlockPos blockPos, @Nullable Entity entity2) {
        AlienEntity alienEntity;
        AlienEntity alienEntity2 = this.mob;
        if (alienEntity2 instanceof AlienEntity) {
            alienEntity = alienEntity2;
            if (!alienEntity.crawlingManager.isCrawling()) {
                ++alienEntity.wakeupCounter;
                if (!alienEntity.stasisManager.isStasis() || alienEntity.wakeupCounter < 3) {
                    // empty if block
                }
                if (alienEntity.wakeupCounter >= 3) {
                    LivingEntity livingEntity;
                    if (alienEntity.stasisManager.isStasis()) {
                        alienEntity.animationDispatcher.sendStatisLeave();
                        alienEntity.stasisManager.setStasis(false);
                    }
                    if (entity2 instanceof LivingEntity && GigEntityUtils.TARGET_PREDICATE.test(alienEntity, livingEntity = (LivingEntity)entity2)) {
                        this.mob.setTarget(livingEntity);
                    }
                    alienEntity.getNavigation().moveTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 1.0);
                    alienEntity.wakeupCounter = 0;
                }
            }
        }
        if ((alienEntity2 = this.mob) instanceof AlienEntity) {
            alienEntity = alienEntity2;
            if (alienEntity.crawlingManager.isCrawling()) {
                alienEntity.stasisManager.setStasis(false);
                alienEntity.getNavigation().moveTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 1.0);
            }
        }
        if (this.mob instanceof PopperEntity || this.mob instanceof HammerpedeEntity || this.mob instanceof FacehuggerEntity && !(entity2 instanceof IronGolem)) {
            this.mob.getNavigation().moveTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 1.0);
        }
    }
}

