/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper;

import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.particle.GigParticles;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.helper.states.EggStates;
import mods.cybercat.gigeresque.common.entity.impl.classic.AlienEggEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;

public record GigCommonMethods() {
    public static void setAnimation(Runnable animationAction) {
        animationAction.run();
    }

    public static Entity generateBloodPool(LivingEntity entity, BlockPos pos, int xOffset, int zOffset) {
        Entity bloodEntity = GigEntities.BLOOD.get().create(entity.level());
        assert (bloodEntity != null);
        bloodEntity.moveTo(pos.offset(xOffset, 0, zOffset), entity.getYRot(), entity.getXRot());
        entity.level().addFreshEntity(bloodEntity);
        return bloodEntity;
    }

    public static Entity generateAcidPool(LivingEntity entity, BlockPos pos, int xOffset, int zOffset) {
        Entity acidEntity = GigEntities.ACID.get().create(entity.level());
        assert (acidEntity != null);
        acidEntity.moveTo(pos.offset(xOffset, 0, zOffset), entity.getYRot(), entity.getXRot());
        entity.level().addFreshEntity(acidEntity);
        return acidEntity;
    }

    public static Entity generateAcidPoolAtPos(Level level, BlockPos pos, int xOffset, int zOffset) {
        Entity acidEntity = GigEntities.ACID.get().create(level);
        assert (acidEntity != null);
        acidEntity.moveTo(pos.offset(0, 1, 0), (float)xOffset, (float)zOffset);
        level.addFreshEntity(acidEntity);
        return acidEntity;
    }

    public static Entity generateGooBlood(LivingEntity entity, BlockPos pos, int xOffset, int zOffset) {
        Entity gooEntity = GigEntities.GOO.get().create(entity.level());
        assert (gooEntity != null);
        gooEntity.moveTo(pos.offset(xOffset, 0, zOffset), entity.getYRot(), entity.getXRot());
        entity.level().addFreshEntity(gooEntity);
        return gooEntity;
    }

    public static Entity generateGooBloodAtPos(Level level, BlockPos pos, int xOffset, int zOffset) {
        Entity gooEntity = GigEntities.GOO.get().create(level);
        assert (gooEntity != null);
        gooEntity.moveTo(pos.offset(0, 1, 0), (float)xOffset, (float)zOffset);
        level.addFreshEntity(gooEntity);
        return gooEntity;
    }

    public static Entity generateSporeCloud(LivingEntity entity, BlockPos pos, int xOffset, int zOffset, float radius) {
        AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(entity.level(), (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ());
        areaEffectCloudEntity.setRadius(radius);
        areaEffectCloudEntity.setDuration(150);
        areaEffectCloudEntity.setRadiusPerTick(-areaEffectCloudEntity.getRadius() / (float)areaEffectCloudEntity.getDuration());
        areaEffectCloudEntity.setParticle((ParticleOptions)ParticleTypes.ASH);
        if (!entity.hasEffect(GigStatusEffects.SPORE)) {
            areaEffectCloudEntity.addEffect(new MobEffectInstance(GigStatusEffects.SPORE, CommonMod.config.alienblockConfigs.sporeTickTimer, 0));
        }
        entity.level().addFreshEntity((Entity)areaEffectCloudEntity);
        return areaEffectCloudEntity;
    }

    public static void handleNestProgress(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.getEggState() == EggStates.HATCHED.ordinal() && alienEggEntity.isAlive()) {
            float f = alienEggEntity.ticksUntilNest;
            alienEggEntity.ticksUntilNest = f + 1.0f;
            alienEggEntity.setTicksUntilNest(f);
            if (alienEggEntity.getTicksUntilNest() >= 6000.0f) {
                if (alienEggEntity.level().isClientSide) {
                    GigCommonMethods.spawnParticlesForNesting(alienEggEntity);
                }
                alienEggEntity.level().setBlockAndUpdate(alienEggEntity.blockPosition(), GigBlocks.NEST_RESIN_WEB_CROSS.get().defaultBlockState());
                alienEggEntity.kill();
            }
        }
    }

    public static void spawnParticlesForNesting(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.getTicksUntilNest() == 6000.0f) {
            for (int i = 0; i < 2; ++i) {
                alienEggEntity.level().addAlwaysVisibleParticle((ParticleOptions)GigParticles.GOO.get(), alienEggEntity.getRandomX(1.0), alienEggEntity.getRandomY(), alienEggEntity.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void handleHatchingProgress(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.getEggState() == EggStates.HATCHING.ordinal()) {
            if (alienEggEntity.hatchProgress < 50L) {
                ++alienEggEntity.hatchProgress;
            }
            if (alienEggEntity.hatchProgress == 2L) {
                alienEggEntity.level().playSound((Entity)alienEggEntity, alienEggEntity.blockPosition(), GigSounds.EGG_OPEN.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (alienEggEntity.hatchProgress >= 50L) {
                alienEggEntity.setEggState(EggStates.HATCHED.ordinal());
                ++alienEggEntity.ticksOpen;
            }
        }
        if (alienEggEntity.getEggState() == EggStates.HATCHED.ordinal() && alienEggEntity.hasFacehugger()) {
            ++alienEggEntity.ticksOpen;
        }
    }

    public static void handleFacehuggerSpawn(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.ticksOpen >= 60L && alienEggEntity.hasFacehugger() && !alienEggEntity.isDeadOrDying()) {
            FacehuggerEntity facehugger = (FacehuggerEntity)GigEntities.FACEHUGGER.get().create(alienEggEntity.level());
            if (facehugger != null) {
                facehugger.setPos(alienEggEntity.position().x, alienEggEntity.position().y + 1.0, alienEggEntity.position().z);
                facehugger.setDeltaMovement(Mth.nextFloat((RandomSource)facehugger.getRandom(), (float)-0.5f, (float)0.5f), 0.7, Mth.nextFloat((RandomSource)facehugger.getRandom(), (float)-0.5f, (float)0.5f));
                alienEggEntity.level().addFreshEntity((Entity)facehugger);
            }
            alienEggEntity.setHasFacehugger(false);
        }
    }

    public static void handleAoEEntityHatchCheck(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.hatchCheckTimer >= 20) {
            alienEggEntity.hatchCheckTimer = 0;
            alienEggEntity.level().getEntitiesOfClass(LivingEntity.class, alienEggEntity.getBoundingBox().inflate(CommonMod.config.entityConfigs.eggConfigs.alieneggHatchRange)).forEach(target -> {
                if (target.isAlive() && GigEntityUtils.faceHuggerTest(target) && alienEggEntity.level().random.nextFloat() < 0.2f && !target.isSteppingCarefully() && Constants.isNotCreativeSpecPlayer.test((Entity)target)) {
                    alienEggEntity.setEggState(EggStates.HATCHING.ordinal());
                }
            });
            alienEggEntity.level().getEntitiesOfClass(LivingEntity.class, alienEggEntity.getBoundingBox().inflate(3.0)).forEach(target -> {
                Player player;
                if (target.isAlive() && GigEntityUtils.faceHuggerTest(target) && alienEggEntity.level().random.nextFloat() < 0.8f && (target instanceof Player && !(player = (Player)target).isCreative() && !player.isSpectator() || !(target instanceof Player))) {
                    alienEggEntity.setEggState(EggStates.HATCHING.ordinal());
                }
            });
        }
    }

    public static void handleAoEBlockHatchCheck(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.getLastHurtMob() == null) {
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)alienEggEntity.blockPosition().above(1), (BlockPos)alienEggEntity.blockPosition().above(1))) {
                for (BlockPos testPos1 : BlockPos.betweenClosed((BlockPos)alienEggEntity.blockPosition().below(1), (BlockPos)alienEggEntity.blockPosition().below(1))) {
                    for (BlockPos testPos2 : BlockPos.betweenClosed((BlockPos)alienEggEntity.blockPosition().east(1), (BlockPos)alienEggEntity.blockPosition().east(1))) {
                        for (BlockPos testPos3 : BlockPos.betweenClosed((BlockPos)alienEggEntity.blockPosition().west(1), (BlockPos)alienEggEntity.blockPosition().west(1))) {
                            for (BlockPos testPos4 : BlockPos.betweenClosed((BlockPos)alienEggEntity.blockPosition().south(1), (BlockPos)alienEggEntity.blockPosition().south(1))) {
                                for (BlockPos testPos5 : BlockPos.betweenClosed((BlockPos)alienEggEntity.blockPosition().north(1), (BlockPos)alienEggEntity.blockPosition().north(1))) {
                                    boolean isAnyBlockSolid;
                                    boolean isAnyBlockNotAir = !alienEggEntity.level().getBlockState(testPos).isAir() && !alienEggEntity.level().getBlockState(testPos1).isAir() && !alienEggEntity.level().getBlockState(testPos2).isAir() && !alienEggEntity.level().getBlockState(testPos3).isAir() && !alienEggEntity.level().getBlockState(testPos4).isAir() && !alienEggEntity.level().getBlockState(testPos5).isAir();
                                    boolean bl = isAnyBlockSolid = !alienEggEntity.level().getBlockState(testPos).isCollisionShapeFullBlock((BlockGetter)alienEggEntity.level(), testPos) && !alienEggEntity.level().getBlockState(testPos1).isCollisionShapeFullBlock((BlockGetter)alienEggEntity.level(), testPos1) && !alienEggEntity.level().getBlockState(testPos2).isCollisionShapeFullBlock((BlockGetter)alienEggEntity.level(), testPos2) && !alienEggEntity.level().getBlockState(testPos3).isCollisionShapeFullBlock((BlockGetter)alienEggEntity.level(), testPos3) && !alienEggEntity.level().getBlockState(testPos4).isCollisionShapeFullBlock((BlockGetter)alienEggEntity.level(), testPos4) && !alienEggEntity.level().getBlockState(testPos5).isCollisionShapeFullBlock((BlockGetter)alienEggEntity.level(), testPos5);
                                    if (!isAnyBlockSolid && !isAnyBlockNotAir) continue;
                                    alienEggEntity.setEggState(EggStates.IDLE.ordinal());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static void handlePlayerInteraction(AlienEggEntity alienEggEntity) {
        if (alienEggEntity.getLastHurtMob() != null) {
            alienEggEntity.setEggState(EggStates.HATCHING.ordinal());
        }
    }

    public static void handleFloatingPhysics(Entity alienEgg) {
        alienEgg.xo = alienEgg.getX();
        alienEgg.yo = alienEgg.getY();
        alienEgg.zo = alienEgg.getZ();
        Vec3 motion = alienEgg.getDeltaMovement();
        double adjustedY = motion.y + (double)(motion.y < (double)0.06f ? 5.0E-4f : 0.0f);
        if (GigCommonMethods.isFloatingInFluid(alienEgg, (TagKey<Fluid>)FluidTags.WATER) || GigCommonMethods.isFloatingInFluid(alienEgg, (TagKey<Fluid>)FluidTags.LAVA)) {
            alienEgg.setDeltaMovement(motion.x * 0.99, adjustedY, motion.z * 0.99);
        } else {
            alienEgg.applyGravity();
        }
    }

    public static boolean isFloatingInFluid(Entity alienEgg, TagKey<Fluid> fluidTag) {
        return alienEgg.isInWater() && alienEgg.getFluidHeight(fluidTag) > 0.1;
    }

    public static void handleCollisionPhysics(Entity alienEgg) {
        if (alienEgg.level().isClientSide) {
            alienEgg.noPhysics = false;
        } else {
            boolean bl = alienEgg.noPhysics = !alienEgg.level().noCollision(alienEgg, alienEgg.getBoundingBox().deflate(1.0E-7));
            if (alienEgg.noPhysics) {
                GigCommonMethods.moveToClosestSpace(alienEgg);
            }
        }
    }

    public static void moveToClosestSpace(Entity alienEgg) {
        alienEgg.moveTowardsClosestSpace(alienEgg.getX(), (alienEgg.getBoundingBox().minY + alienEgg.getBoundingBox().maxY) / 1.5, alienEgg.getZ());
    }

    public static void handleMovement(Entity alienEgg) {
        if (GigCommonMethods.shouldApplyMovement(alienEgg)) {
            alienEgg.move(MoverType.SELF, alienEgg.getDeltaMovement());
            float friction = GigCommonMethods.getGroundFriction(alienEgg);
            alienEgg.setDeltaMovement(alienEgg.getDeltaMovement().multiply((double)friction, 0.78, (double)friction));
            GigCommonMethods.handleGroundImpact(alienEgg);
        }
    }

    public static boolean shouldApplyMovement(Entity alienEgg) {
        return !alienEgg.onGround() || alienEgg.getDeltaMovement().horizontalDistanceSqr() > 1.0E-5 || (alienEgg.tickCount + alienEgg.getId()) % 4 == 0;
    }

    public static float getGroundFriction(Entity alienEgg) {
        if (alienEgg.onGround()) {
            return alienEgg.level().getBlockState(alienEgg.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
        }
        return 0.98f;
    }

    public static void handleGroundImpact(Entity alienEgg) {
        if (alienEgg.onGround()) {
            Vec3 motion = alienEgg.getDeltaMovement();
            if (motion.y < 0.0) {
                alienEgg.setDeltaMovement(motion.multiply(1.0, -0.1, 1.0));
            }
        }
    }
}

