/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.aqua;

import mod.azure.azurelib.common.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.ai.goals.RotateTowardsEntityGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.BreakBlocksGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedAttackGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.LungeAtTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.DigToTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.DodgeProjectilesGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FindDarknessGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeExplodingCreeperGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFightGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFireGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.StrollAroundInWaterGoal;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.GigMeleeAttackSelector;
import mods.cybercat.gigeresque.common.entity.impl.misc.AquaEggEntity;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquaticAlienEntity
extends AlienEntity {
    public int killCounter;

    public AquaticAlienEntity(EntityType<? extends AlienEntity> type, Level world) {
        super(type, world);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
        this.animationSelector = GigMeleeAttackSelector.STANDARD_ANIM_SELECTOR;
    }

    @Override
    public int getAcidDiameter() {
        return 3;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, CommonMod.config.entityConfigs.aquaticXenoConfigs.aquaticXenoHealth).add(Attributes.ARMOR, CommonMod.config.entityConfigs.aquaticXenoConfigs.aquaticXenoArmor).add(Attributes.ARMOR_TOUGHNESS, 9.0).add(Attributes.KNOCKBACK_RESISTANCE, 9.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.3300000041723251).add(Attributes.ATTACK_DAMAGE, CommonMod.config.entityConfigs.aquaticXenoConfigs.aquaticXenoAttackDamage).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    @Override
    public float getGrowthMultiplier() {
        return CommonMod.config.entityConfigs.aquaticXenoConfigs.aquaticAlienGrowthMultiplier;
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        if (this.wasEyeInWater) {
            return EntityDimensions.scalable((float)2.0f, (float)1.0f);
        }
        return EntityDimensions.scalable((float)0.9f, (float)(this.crawlingManager.isCrawling() ? 0.4f : 1.75f));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType != MobSpawnType.NATURAL) {
            this.setGrowth(this.getMaxGrowth());
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FleeExplodingCreeperGoal(this));
        this.goalSelector.addGoal(0, (Goal)new DodgeProjectilesGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new DelayedAttackGoal(this, 1.25, 5));
        this.goalSelector.addGoal(1, (Goal)new FleeFightGoal(this));
        this.goalSelector.addGoal(3, (Goal)new LungeAtTargetGoal((Mob)this, 0.05f, 200, 16.0).setOnLungeCallback(() -> this.runLungeAnimation()));
        this.goalSelector.addGoal(4, (Goal)new BreakBlocksGoal(this, GigTags.DESTRUCTIBLE_LIGHT, 1.5f));
        this.goalSelector.addGoal(5, (Goal)new DigToTargetGoal(this, 32.0));
        this.goalSelector.addGoal(5, (Goal)new FleeFireGoal(this));
        this.goalSelector.addGoal(7, (Goal)new FindDarknessGoal(this));
        this.goalSelector.addGoal(9, (Goal)new RotateTowardsEntityGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new RotateTowardsEntityGoal((Mob)this, LivingEntity.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AlienEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> this.getHealth() > this.getMaxHealth() / 2.0f && GigEntityUtils.isValidAquaTarget(target)));
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (!this.level().isClientSide && this.getRandom().nextInt(0, 10) > 7) {
                if (target instanceof Player) {
                    Player playerEntity = (Player)target;
                    playerEntity.drop(playerEntity.getInventory().getSelected(), false);
                    playerEntity.getInventory().setItem(playerEntity.getInventory().selected, ItemStack.EMPTY);
                }
                if (livingEntity instanceof Mob) {
                    Mob mobEntity = (Mob)livingEntity;
                    mobEntity.getMainHandItem();
                    this.drop((LivingEntity)mobEntity, mobEntity.getMainHandItem());
                    mobEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.AIR));
                }
                livingEntity.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 1.0f, 1.0f);
                livingEntity.hurt(this.damageSources().mobAttack((LivingEntity)this), this.getRandom().nextInt(4) > 2 ? CommonMod.config.entityConfigs.aquaticXenoConfigs.aquaticXenoTailAttackDamage : 0.0f);
                this.heal(1.0833f);
            }
        }
        this.heal(1.0833f);
        return super.doHurtTarget(target);
    }

    public boolean killedEntity(@NotNull ServerLevel level, @NotNull LivingEntity entity) {
        if (entity.getType().is(EntityTypeTags.AQUATIC)) {
            ++this.killCounter;
        }
        return super.killedEntity(level, entity);
    }

    @Override
    public void tick() {
        super.tick();
        this.moveAnalysis.update();
        if (this.killCounter >= 3) {
            AquaEggEntity aquaEgg = (AquaEggEntity)GigEntities.AQUA_EGG.get().create(this.level());
            if (aquaEgg != null) {
                aquaEgg.setPos(this.getX(), this.getY(), this.getZ());
                this.level().addFreshEntity((Entity)aquaEgg);
            }
            this.killCounter = 0;
        }
    }
}

