/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.rom;

import java.util.SplittableRandom;
import mod.azure.azurelib.common.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.BreakBlocksGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedClassicAttackGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.HeadBiteGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.LungeAtTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.DigToTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.DodgeProjectilesGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FindDarknessGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFightGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFireGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.StrollAroundInWaterGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.nest.BuildNestGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.nest.EggmorphGoal;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.AzureVibrationUser;
import mods.cybercat.gigeresque.common.entity.helper.GigMeleeAttackSelector;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RomAlienEntity
extends AlienEntity {
    public RomAlienEntity(@NotNull EntityType<? extends AlienEntity> type, @NotNull Level world) {
        super(type, world);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
        this.vibrationUser = new AzureVibrationUser(this, 1.5f);
        this.animationSelector = GigMeleeAttackSelector.CLASSIC_ANIM_SELECTOR;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, CommonMod.config.entityConfigs.classicXenoConfigs.classicXenoHealth).add(Attributes.ARMOR, CommonMod.config.entityConfigs.classicXenoConfigs.classicXenoArmor).add(Attributes.ARMOR_TOUGHNESS, 7.0).add(Attributes.KNOCKBACK_RESISTANCE, 8.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.3300000041723251).add(Attributes.ATTACK_DAMAGE, CommonMod.config.entityConfigs.classicXenoConfigs.classicXenoAttackDamage).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    @Override
    public int getAcidDiameter() {
        return 3;
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        if (this.wasEyeInWater) {
            return EntityDimensions.scalable((float)3.0f, (float)1.0f);
        }
        return EntityDimensions.scalable((float)0.9f, (float)(this.crawlingManager.isCrawling() ? 0.4f : 2.9f));
    }

    @Override
    public void tick() {
        super.tick();
        this.moveAnalysis.update();
        if (!this.isVehicle()) {
            this.setIsExecuting(false);
        }
    }

    @Override
    public float getGrowthMultiplier() {
        return CommonMod.config.entityConfigs.classicXenoConfigs.alienGrowthMultiplier;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType != MobSpawnType.NATURAL) {
            this.setGrowth(this.getMaxGrowth());
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (!this.level().isClientSide && this.getRandom().nextInt(0, 10) > 7) {
                if (target instanceof Player) {
                    Player playerEntity = (Player)target;
                    playerEntity.drop(playerEntity.getInventory().getSelected(), false);
                    playerEntity.getInventory().setItem(playerEntity.getInventory().selected, ItemStack.EMPTY);
                }
                if (livingEntity instanceof Mob) {
                    Mob mobEntity = (Mob)livingEntity;
                    mobEntity.getMainHandItem();
                    this.drop((LivingEntity)mobEntity, mobEntity.getMainHandItem());
                    mobEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.AIR));
                }
                livingEntity.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 1.0f, 1.0f);
                livingEntity.hurt(GigDamageSources.of(this.level(), GigDamageSources.XENO), this.getRandom().nextInt(4) > 2 ? CommonMod.config.entityConfigs.classicXenoConfigs.classicXenoTailAttackDamage : (float)CommonMod.config.entityConfigs.classicXenoConfigs.classicXenoAttackDamage);
                this.heal(1.0833f);
                return super.doHurtTarget(target);
            }
        }
        this.heal(1.0833f);
        return super.doHurtTarget(target);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new DodgeProjectilesGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new DelayedClassicAttackGoal(this, 1.25, 5));
        this.goalSelector.addGoal(2, (Goal)new HeadBiteGoal(this));
        this.goalSelector.addGoal(3, (Goal)new LungeAtTargetGoal((Mob)this, 0.05f, 200, 16.0).setOnLungeCallback(() -> this.runLungeAnimation()));
        this.goalSelector.addGoal(3, (Goal)new EggmorphGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BreakBlocksGoal(this, GigTags.DESTRUCTIBLE_LIGHT, 1.5f));
        this.goalSelector.addGoal(1, (Goal)new FleeFightGoal(this));
        this.goalSelector.addGoal(5, (Goal)new DigToTargetGoal(this, 32.0));
        this.goalSelector.addGoal(5, (Goal)new FleeFireGoal(this));
        this.goalSelector.addGoal(7, (Goal)new BuildNestGoal(this));
        this.goalSelector.addGoal(7, (Goal)new FindDarknessGoal(this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AlienEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> this.getHealth() > this.getMaxHealth() / 2.0f && GigEntityUtils.isValidTarget(target)));
    }

    public void positionRider(@NotNull Entity entity, @NotNull Entity.MoveFunction moveFunction) {
        if (entity instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)entity;
            SplittableRandom random = new SplittableRandom();
            mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 100, true, true));
            float f = Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180)));
            float g = Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180)));
            float y1 = random.nextFloat(0.14f, 0.15f);
            float y3 = random.nextFloat(0.44f, 0.45f);
            float y = random.nextFloat(0.74f, 0.75f);
            float y2 = random.nextFloat(1.14f, 1.15f);
            mob.setPos(this.getX() + (double)((this.isExecuting() ? -2.4f : -1.85f) * f), this.getY() + (double)(this.isExecuting() ? ((double)mob.getBbHeight() < 1.4 ? y2 : y) : ((double)mob.getBbHeight() < 1.4 ? y3 : y1)), this.getZ() - (double)((this.isExecuting() ? -2.4f : -1.85f) * g));
            mob.yBodyRot = this.yBodyRot;
            mob.setSpeed(0.0f);
        }
    }
}

