/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.templebeast;

import mod.azure.azurelib.common.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.BreakBlocksGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.ChargeAtTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedAttackGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FindDarknessGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFightGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFireGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.StrollAroundInWaterGoal;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.GigMeleeAttackSelector;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RavenousTempleBeastEntity
extends AlienEntity {
    public RavenousTempleBeastEntity(EntityType<? extends AlienEntity> entityType, Level level) {
        super(entityType, level);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
        this.animationSelector = GigMeleeAttackSelector.NORMAL_ANIM_SELECTOR;
    }

    @Override
    public int getAcidDiameter() {
        return 3;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, CommonMod.config.entityConfigs.ravenousTempleBeastConfigs.ravenousTempleBeastXenoHealth).add(Attributes.ARMOR, CommonMod.config.entityConfigs.ravenousTempleBeastConfigs.ravenousTempleBeastXenoArmor).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.3300000041723251).add(Attributes.ATTACK_DAMAGE, CommonMod.config.entityConfigs.ravenousTempleBeastConfigs.ravenousTempleBeastAttackDamage).add(Attributes.ATTACK_KNOCKBACK, 0.3);
    }

    @Override
    public void tick() {
        super.tick();
        this.moveAnalysis.update();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new DelayedAttackGoal(this, 1.15f, 7));
        this.goalSelector.addGoal(1, (Goal)new FleeFightGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ChargeAtTargetGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BreakBlocksGoal(this, GigTags.DESTRUCTIBLE_LIGHT, 1.5f));
        this.goalSelector.addGoal(5, (Goal)new FleeFireGoal(this));
        this.goalSelector.addGoal(7, (Goal)new FindDarknessGoal(this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AlienEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> this.getHealth() > this.getMaxHealth() / 2.0f && GigEntityUtils.isValidTarget(target)));
    }
}

