/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.item;

import java.util.List;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SurgeryKitItem
extends Item {
    public SurgeryKitItem() {
        super(new Item.Properties().durability(CommonMod.config.generalConfigs.maxSurgeryKitUses));
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack itemStack, @NotNull Player player, LivingEntity livingEntity, @NotNull InteractionHand interactionHand) {
        if (livingEntity.getPassengers().stream().noneMatch(FacehuggerEntity.class::isInstance) && livingEntity.hasEffect(GigStatusEffects.IMPREGNATION)) {
            int currentDurability = itemStack.getDamageValue();
            int maxDurability = itemStack.getMaxDamage();
            double killChance = this.calculateKillChance(currentDurability, maxDurability);
            this.tryRemoveParasite(itemStack, livingEntity);
            player.getCooldowns().addCooldown((Item)this, CommonMod.config.generalConfigs.surgeryKitCooldownTicks);
            itemStack.hurtAndBreak(1, (LivingEntity)player, livingEntity.getEquipmentSlotForItem(itemStack));
            if (player.hasEffect(GigStatusEffects.IMPREGNATION)) {
                player.removeEffect(GigStatusEffects.IMPREGNATION);
            }
            if (currentDurability < maxDurability && (double)livingEntity.getRandom().nextInt(0, 100) < killChance) {
                livingEntity.hurt(GigDamageSources.of(livingEntity.level(), GigDamageSources.FAILED_SURGERY), Float.MAX_VALUE);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(Constants.modResource("surgery_kit"));
                if (advancement != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                    for (String s : serverPlayer.getAdvancements().getOrStartProgress(advancement).getRemainingCriteria()) {
                        serverPlayer.getAdvancements().award(advancement, s);
                    }
                }
            }
        }
        return super.interactLivingEntity(itemStack, player, livingEntity, interactionHand);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player user, @NotNull InteractionHand hand) {
        if (user.getPassengers().stream().noneMatch(FacehuggerEntity.class::isInstance) && user.hasEffect(GigStatusEffects.IMPREGNATION)) {
            ItemStack itemStack = user.getItemInHand(hand);
            int currentDurability = itemStack.getDamageValue();
            int maxDurability = itemStack.getMaxDamage();
            double killChance = this.calculateKillChance(currentDurability, maxDurability);
            this.tryRemoveParasite(user.getItemInHand(hand), (LivingEntity)user);
            if (user.hasEffect(GigStatusEffects.IMPREGNATION)) {
                user.removeEffect(GigStatusEffects.IMPREGNATION);
            }
            if (currentDurability < maxDurability && (double)user.getRandom().nextInt(0, 100) < killChance) {
                user.hurt(GigDamageSources.of(user.level(), GigDamageSources.FAILED_SURGERY), Float.MAX_VALUE);
            }
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)user;
                AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(Constants.modResource("surgery_kit"));
                if (advancement != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                    for (String s : serverPlayer.getAdvancements().getOrStartProgress(advancement).getRemainingCriteria()) {
                        serverPlayer.getAdvancements().award(advancement, s);
                    }
                }
            }
        }
        return super.use(world, user, hand);
    }

    private double calculateKillChance(int currentDurability, int maxDurability) {
        int durabilityLost = maxDurability - currentDurability;
        return (double)durabilityLost / (double)maxDurability * 0.4;
    }

    private void tryRemoveParasite(ItemStack stack, LivingEntity entity) {
        if (entity.hasEffect(GigStatusEffects.IMPREGNATION) || entity.hasEffect(GigStatusEffects.SPORE) && !entity.level().isClientSide) {
            entity.removeEffect(MobEffects.HUNGER);
            entity.removeEffect(MobEffects.WEAKNESS);
            entity.removeEffect(MobEffects.DIG_SLOWDOWN);
            entity.addEffect(new MobEffectInstance(GigStatusEffects.TRAUMA, 600, 0, false, false, true));
            LivingEntity burster = GigEntityUtils.spawnBurster(entity);
            if (burster != null) {
                SurgeryKitItem.setBursterProperties(entity, burster);
                entity.level().addFreshEntity((Entity)burster);
                entity.level().playSound((Entity)entity, entity.blockPosition(), GigSounds.CHESTBURSTING.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
            }
            if (entity instanceof Player) {
                Player playerentity = (Player)entity;
                playerentity.getCooldowns().addCooldown((Item)this, CommonMod.config.generalConfigs.surgeryKitCooldownTicks);
                stack.hurtAndBreak(1, (LivingEntity)playerentity, playerentity.getEquipmentSlotForItem(stack));
            }
            entity.removeEffect(GigStatusEffects.IMPREGNATION);
        }
    }

    private static void setBursterProperties(LivingEntity entity, LivingEntity burster) {
        if (entity.hasCustomName()) {
            burster.setCustomName(entity.getCustomName());
        }
        burster.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 10), (Entity)burster);
        burster.moveTo(entity.blockPosition(), entity.getYRot(), entity.getXRot());
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.gigeresque.surgery_kit.tooltip1").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC));
        tooltipComponents.add((Component)Component.translatable((String)"item.gigeresque.surgery_kit.tooltip2").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

