/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.status.effect.impl;

import mod.azure.azurelib.core.object.Color;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.impl.classic.AlienEggEntity;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class EggMorphingStatusEffect
extends MobEffect {
    public EggMorphingStatusEffect() {
        super(MobEffectCategory.NEUTRAL, Color.BLACK.getColor());
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        super.applyEffectTick(entity, amplifier);
        if (GigEntityUtils.isTargetHostable((Entity)entity) && this == GigStatusEffects.EGGMORPHING) {
            entity.heal(0.0f);
        }
        return super.applyEffectTick(entity, amplifier);
    }

    public static void effectRemoval(@NotNull LivingEntity entity, MobEffectInstance mobEffectInstance) {
        if (Constants.isCreativeSpecPlayer.test((Entity)entity)) {
            return;
        }
        if (!GigEntityUtils.isTargetHostable((Entity)entity)) {
            return;
        }
        if (entity.level().isClientSide || !(mobEffectInstance.getEffect().value() instanceof EggMorphingStatusEffect)) {
            return;
        }
        if (!entity.level().getBlockState(entity.blockPosition()).is(GigBlocks.NEST_RESIN_WEB_CROSS.get())) {
            return;
        }
        AlienEggEntity egg = new AlienEggEntity((EntityType<? extends AlienEggEntity>)GigEntities.EGG.get(), entity.level());
        egg.moveTo(entity.blockPosition(), entity.getYRot(), entity.getXRot());
        if (entity.level().getBlockState(entity.blockPosition()).is(GigTags.NEST_BLOCKS)) {
            entity.level().setBlockAndUpdate(entity.blockPosition(), Blocks.AIR.defaultBlockState());
        }
        if (entity.level().getBlockState(entity.blockPosition().above()).is(GigTags.NEST_BLOCKS)) {
            entity.level().setBlockAndUpdate(entity.blockPosition().above(), Blocks.AIR.defaultBlockState());
        }
        entity.level().addFreshEntity((Entity)egg);
        entity.hurt(GigDamageSources.of(entity.level(), GigDamageSources.EGGMORPHING), 2.1474836E9f);
    }
}

