/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBreakProgressManager {
    private static final Map<BlockPos, Map.Entry<Long, Float>> BLOCK_BREAK_PROGRESS_MAP = new HashMap<BlockPos, Map.Entry<Long, Float>>();

    public static void tick(Level level) {
        long gameTime = level.getGameTime();
        if (gameTime % 400L != 0L) {
            return;
        }
        BLOCK_BREAK_PROGRESS_MAP.entrySet().removeIf(entry -> {
            Long lastUpdateTimeMillis = (Long)((Map.Entry)entry.getValue()).getKey();
            return System.currentTimeMillis() > lastUpdateTimeMillis;
        });
    }

    public static void resetProgress(Level level, BlockPos pos) {
        BLOCK_BREAK_PROGRESS_MAP.remove(pos);
        level.destroyBlockProgress(BlockBreakProgressManager.computeBlockPosHash(pos), pos, -1);
    }

    public static void setProgress(Level level, BlockPos pos, float progress) {
        Map.Entry<Long, Float> newEntry = Map.entry(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L), Float.valueOf(progress));
        BLOCK_BREAK_PROGRESS_MAP.put(pos, newEntry);
        int clampedProgress = BlockBreakProgressManager.getClampedProgress(progress);
        level.destroyBlockProgress(BlockBreakProgressManager.computeBlockPosHash(pos), pos, clampedProgress);
    }

    public static Result damage(Level level, BlockPos blockPos, float damage) {
        BlockPos immutableBlockPos = blockPos.immutable();
        Map.Entry<Long, Float> entry = BLOCK_BREAK_PROGRESS_MAP.get(immutableBlockPos);
        BlockState blockState = level.getBlockState(immutableBlockPos);
        Block block = blockState.getBlock();
        float currentDestroyProgress = entry == null ? 0.0f : entry.getValue().floatValue();
        float defaultDestroyTimeInSeconds = block.defaultDestroyTime();
        if (defaultDestroyTimeInSeconds < 0.0f || blockState.is(Blocks.FIRE)) {
            return Result.NOT_DAMAGED;
        }
        float destroyTimeInTicks = block.defaultDestroyTime() * 20.0f;
        float weight = Math.max(destroyTimeInTicks, 1.0f);
        float newDestroyProgress = currentDestroyProgress + damage / weight;
        if (newDestroyProgress >= 9.0f) {
            BlockBreakProgressManager.resetProgress(level, immutableBlockPos);
            level.destroyBlock(immutableBlockPos, false);
            return Result.DESTROYED;
        }
        BlockBreakProgressManager.setProgress(level, immutableBlockPos, newDestroyProgress);
        return Result.DAMAGED;
    }

    private static int getClampedProgress(float progress) {
        return (int)Mth.clamp((float)progress, (float)-1.0f, (float)9.0f);
    }

    private static int computeBlockPosHash(BlockPos pos) {
        return Objects.hash(pos);
    }

    private BlockBreakProgressManager() {
        throw new UnsupportedOperationException();
    }

    public static enum Result {
        DAMAGED,
        DESTROYED,
        NOT_DAMAGED;

    }
}

