/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.mixins.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.entity.texture.EntityTextures;
import mods.cybercat.gigeresque.common.fluid.GigFluids;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ScreenEffectRenderer.class})
public class InGameOverlayRendererMixin {
    private static int fovEggticker = 0;

    @Inject(method={"renderScreenEffect"}, at={@At(value="RETURN")})
    private static void gigeresque$renderOverlays(Minecraft client, PoseStack matrices, CallbackInfo ci) {
        assert (client.player != null);
        if (!client.player.isSpectator()) {
            float effectDur;
            double d = client.player.getEyeY() - 0.1111111119389534;
            BlockPos blockPos = BlockPos.containing((double)client.player.getX(), (double)d, (double)client.player.getZ());
            FluidState fluidState = client.player.level().getFluidState(blockPos);
            if (fluidState.is((Fluid)GigFluids.BLACK_FLUID_STILL.get()) || fluidState.is((Fluid)GigFluids.BLACK_FLUID_FLOWING.get())) {
                InGameOverlayRendererMixin.gigeresque$renderOverlay(client, matrices, 1.0f, EntityTextures.BLACK_FLUID_TEXTURE);
            }
            if (Constants.isNotCreativeSpecPlayer.test((Entity)client.player) && client.player.hasEffect(GigStatusEffects.DNA)) {
                effectDur = client.player.getEffect(GigStatusEffects.DNA).getDuration();
                float dnaDuration = 1.0f - Math.clamp(effectDur / (float)CommonMod.config.getgooEffectTickTimer(), 0.0f, 1.0f);
                InGameOverlayRendererMixin.gigeresque$renderOverlay(client, matrices, dnaDuration, EntityTextures.BLACK_FLUID_TEXTURE);
            }
            if (Constants.isNotCreativeSpecPlayer.test((Entity)client.player) && client.player.hasEffect(GigStatusEffects.EGGMORPHING)) {
                effectDur = client.player.getEffect(GigStatusEffects.EGGMORPHING).getDuration();
                float eggmorphingProgress = 1.0f - Math.clamp(effectDur / CommonMod.config.getEggmorphTickTimer(), 0.0f, 1.0f);
                InGameOverlayRendererMixin.gigeresque$renderOverlay(client, matrices, eggmorphingProgress, EntityTextures.EGGMORPH_OVERLAY_TEXTURE);
            }
        }
    }

    @Unique
    private static void gigeresque$renderOverlay(Minecraft minecraft, PoseStack poseStack, float progress, ResourceLocation resourceLocation) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        BlockPos blockpos = BlockPos.containing((double)minecraft.player.getX(), (double)minecraft.player.getEyeY(), (double)minecraft.player.getZ());
        float f = LightTexture.getBrightness((DimensionType)minecraft.player.level().dimensionType(), (int)minecraft.player.level().getMaxLocalRawBrightness(blockpos));
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)progress);
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -minecraft.player.getYRot() / 64.0f;
        float f8 = minecraft.player.getXRot() / 64.0f;
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(4.0f + f7, 4.0f + f8);
        bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(0.0f + f7, 4.0f + f8);
        bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(0.0f + f7, 0.0f + f8);
        bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(4.0f + f7, 0.0f + f8);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)progress);
        RenderSystem.disableBlend();
    }
}

