/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.function.BiConsumer;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.AzureTicker;
import mods.cybercat.gigeresque.common.entity.helper.AzureVibrationUser;
import mods.cybercat.gigeresque.common.entity.helper.GigCommonMethods;
import mods.cybercat.gigeresque.common.entity.helper.Growable;
import mods.cybercat.gigeresque.common.entity.helper.managers.AlienNavigationManager;
import mods.cybercat.gigeresque.common.entity.helper.managers.CrawlingManager;
import mods.cybercat.gigeresque.common.entity.helper.managers.SearchingManager;
import mods.cybercat.gigeresque.common.entity.helper.managers.StasisManager;
import mods.cybercat.gigeresque.common.entity.impl.projectile.AcidSpitProjectile;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.DamageSourceUtils;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import mods.cybercat.gigeresque.interfacing.AbstractAlien;
import mods.cybercat.gigeresque.interfacing.AnimationSelector;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2596;
import net.minecraft.class_2752;
import net.minecraft.class_2874;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3730;
import net.minecraft.class_4140;
import net.minecraft.class_4174;
import net.minecraft.class_5425;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import net.minecraft.class_8514;
import net.minecraft.class_8779;
import net.minecraft.class_9334;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AlienEntity
extends class_1588
implements class_1569,
class_8514,
Growable,
AbstractAlien {
    public static final class_2940<class_2338> HOME_BLOCKPOS = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13324);
    public static final class_2940<Boolean> FLEEING_FIRE = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> STATE = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> IS_STASIS = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_CRAWLING = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> WAKING_UP = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> CLIENT_ANGER_LEVEL = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> GROWTH = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Boolean> IS_HISSING = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> IS_SEARCHING = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> IS_EXECUTION = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> IS_HEADBITE = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> STASIS_TICK = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> IS_BIRTHED = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> CARRYING_DAMAGE = class_2945.method_12791(AlienEntity.class, (class_2941)class_2943.field_13320);
    protected int delayBeforeEating = 0;
    protected boolean triggeredAttackAnimation = false;
    private final class_5715<class_8514.class_8516> dynamicGameEventListener;
    public int wakeupCounter = 0;
    public boolean inTwoBlockSpace = false;
    public float growthCounter = 0.0f;
    protected class_8514.class_5719 vibrationUser;
    private class_8514.class_8515 vibrationData;
    public class_2338 savedNestWebCross;
    public SearchingManager searchingManager;
    public AnimationDispatcher animationDispatcher;
    public MoveAnalysis moveAnalysis;
    public final CrawlingManager crawlingManager;
    public final StasisManager stasisManager;
    public AnimationSelector<AlienEntity> animationSelector;
    private final AlienNavigationManager navigationManager;
    private int healCounter;

    protected AlienEntity(class_1299<? extends class_1588> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5985 = true;
        this.crawlingManager = new CrawlingManager((class_1314)this, IS_CRAWLING);
        this.searchingManager = new SearchingManager(this, IS_SEARCHING);
        this.stasisManager = new StasisManager(this, IS_STASIS, STASIS_TICK);
        this.vibrationUser = new AzureVibrationUser(this, 1.0f);
        this.vibrationData = new class_8514.class_8515();
        this.dynamicGameEventListener = new class_5715((class_5714)new class_8514.class_8516((class_8514)this));
        this.navigationManager = new AlienNavigationManager(this, this.field_6207);
        this.method_5941(class_7.field_18, 0.0f);
    }

    public static boolean checkMonsterSpawnRules(@NotNull class_1299<? extends class_1588> type, class_5425 level, @NotNull class_3730 spawnType, @NotNull class_2338 pos, @NotNull class_5819 random) {
        return level.method_8407() != class_1267.field_5801 && (class_3730.method_54987((class_3730)spawnType) || AlienEntity.isDarkEnoughToSpawn(level, pos, random)) && AlienEntity.method_20636(type, (class_1936)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random);
    }

    public static boolean isDarkEnoughToSpawn(class_5425 level, @NotNull class_2338 pos, class_5819 random) {
        if (level.method_8314(class_1944.field_9284, pos) > random.method_43048(32)) {
            return false;
        }
        class_2874 dimensiontype = level.method_8597();
        int i = dimensiontype.method_44223();
        if (i < 15 && level.method_8314(class_1944.field_9282, pos) > i) {
            return false;
        }
        int j = level.method_8410().method_8546() ? level.method_22346(pos, 10) : level.method_22339(pos);
        return j <= dimensiontype.method_44222().method_35008(random);
    }

    public float method_49476() {
        return 1.5f;
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 == 150) {
            this.method_5650(class_1297.class_5529.field_26998);
            super.method_6108();
            this.method_23883((class_1297)this);
        }
    }

    public int method_5748() {
        return 4800;
    }

    @Override
    public int getAcidDiameter() {
        return 0;
    }

    @Override
    public boolean isFleeing() {
        return (Boolean)this.field_6011.method_12789(FLEEING_FIRE);
    }

    @Override
    public void setFleeingStatus(boolean fleeing) {
        this.field_6011.method_12778(FLEEING_FIRE, (Object)fleeing);
    }

    @Override
    public void setWakingUpStatus(boolean passout) {
        this.field_6011.method_12778(WAKING_UP, (Object)passout);
    }

    @Override
    public boolean isWakingUp() {
        return (Boolean)this.field_6011.method_12789(WAKING_UP);
    }

    @Override
    public boolean isExecuting() {
        return (Boolean)this.field_6011.method_12789(IS_EXECUTION);
    }

    @Override
    public void setIsExecuting(boolean isExecuting) {
        this.field_6011.method_12778(IS_EXECUTION, (Object)isExecuting);
    }

    @Override
    public boolean isBiting() {
        return (Boolean)this.field_6011.method_12789(IS_HEADBITE);
    }

    @Override
    public void setIsBiting(boolean isBiting) {
        this.field_6011.method_12778(IS_HEADBITE, (Object)isBiting);
    }

    @Override
    public boolean isHissing() {
        return (Boolean)this.field_6011.method_12789(IS_HISSING);
    }

    @Override
    public void setIsHissing(boolean isHissing) {
        this.field_6011.method_12778(IS_HISSING, (Object)isHissing);
    }

    public boolean isBirthed() {
        return (Boolean)this.field_6011.method_12789(IS_BIRTHED);
    }

    public void setBirthStatus(boolean birth) {
        this.field_6011.method_12778(IS_BIRTHED, (Object)birth);
    }

    @Override
    public float getGrowth() {
        return ((Float)this.field_6011.method_12789(GROWTH)).floatValue();
    }

    @Override
    public void setGrowth(float growth) {
        this.field_6011.method_12778(GROWTH, (Object)Float.valueOf(growth));
    }

    public float getCarryDamage() {
        return ((Float)this.field_6011.method_12789(CARRYING_DAMAGE)).floatValue();
    }

    public void setCarryDamage(float damage) {
        this.field_6011.method_12778(CARRYING_DAMAGE, (Object)Float.valueOf(damage));
    }

    public class_2338 getHomeBlock() {
        return (class_2338)this.field_6011.method_12789(HOME_BLOCKPOS);
    }

    public void setHomeBlock(class_2338 pos) {
        this.field_6011.method_12778(HOME_BLOCKPOS, (Object)pos);
    }

    public boolean hasHomeBlock() {
        return !this.getHomeBlock().equals((Object)class_2338.field_10980);
    }

    public void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FLEEING_FIRE, (Object)false);
        builder.method_56912(STATE, (Object)0);
        builder.method_56912(CLIENT_ANGER_LEVEL, (Object)0);
        builder.method_56912(GROWTH, (Object)Float.valueOf(0.0f));
        builder.method_56912(WAKING_UP, (Object)false);
        builder.method_56912(IS_HISSING, (Object)false);
        builder.method_56912(IS_EXECUTION, (Object)false);
        builder.method_56912(IS_HEADBITE, (Object)false);
        builder.method_56912(IS_BIRTHED, (Object)false);
        builder.method_56912(IS_STASIS, (Object)false);
        builder.method_56912(IS_SEARCHING, (Object)false);
        builder.method_56912(IS_CRAWLING, (Object)false);
        builder.method_56912(STASIS_TICK, (Object)0);
        builder.method_56912(HOME_BLOCKPOS, (Object)class_2338.field_10980);
        builder.method_56912(CARRYING_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        class_8514.class_8515.field_44640.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)CommonMod.LOGGER).error(arg_0)).ifPresent(tag -> compound.method_10566("listener", tag));
        compound.method_10548("growth", this.getGrowth());
        compound.method_10556("wakingup", this.isWakingUp());
        compound.method_10556("isHissing", this.isHissing());
        compound.method_10556("isExecuting", this.isExecuting());
        compound.method_10556("isHeadBite", this.isBiting());
        compound.method_10556("is_birthed", this.isBirthed());
        compound.method_10548("carry_damage", this.getCarryDamage());
        class_2338 homeBlock = this.getHomeBlock();
        if (homeBlock != null) {
            class_2512.method_10692((class_2338)homeBlock);
        }
        this.stasisManager.save(compound);
        this.searchingManager.save(compound);
        this.crawlingManager.save(compound);
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.crawlingManager.load(compound);
        this.searchingManager.load(compound);
        this.stasisManager.load(compound);
        if (compound.method_10573("listener", 10)) {
            class_8514.class_8515.field_44640.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)compound.method_10562("listener"))).resultOrPartial(arg_0 -> ((Logger)CommonMod.LOGGER).error(arg_0)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
        this.setGrowth(compound.method_10583("growth"));
        this.setIsHissing(compound.method_10577("isHissing"));
        this.setIsBiting(compound.method_10577("isHeadBite"));
        this.setIsExecuting(compound.method_10577("isExecuting"));
        this.setIsExecuting(compound.method_10577("isHeadBite"));
        this.setWakingUpStatus(compound.method_10577("wakingup"));
        this.setCarryDamage(compound.method_10583("carry_damage"));
        if (compound.method_10545("is_birthed")) {
            this.setBirthStatus(compound.method_10577("is_birthed"));
        }
        if (compound.method_10545("homeBlock")) {
            this.setHomeBlock(class_2512.method_10691((class_2487)compound, (String)"homeBlock").orElse(class_2338.field_10980));
        }
    }

    protected boolean method_5860(@NotNull class_1297 vehicle) {
        return false;
    }

    public int method_23329(float fallDistance, float damageMultiplier) {
        if (fallDistance <= 15.0f) {
            return 0;
        }
        return super.method_23329(fallDistance, damageMultiplier);
    }

    public int method_5850() {
        return 9;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        this.method_5855(this.method_5748());
        this.searchingManager.tick();
        this.stasisManager.tick();
        if (this.method_5968() != null && !GigEntityUtils.isValidTarget(this.method_5968())) {
            this.method_5980(null);
        }
        this.method_5855(this.method_5748());
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.method_5805()) {
                if (this.getGrowth() <= this.getMaxGrowth() && this.field_6012 % 20 == 0) {
                    if (CommonMod.config.enableLogging && this.getGrowth() > 0.0f) {
                        CommonMod.LOGGER.warn("Current Growth: {} of {} located at {}", (Object)Float.valueOf(this.getGrowth()), (Object)this.method_5476().getString(), (Object)this.method_24515());
                    }
                    this.growthCounter += 1.0f;
                    this.setGrowth((this.getGrowth() + 1.0f) * this.getGrowthMultiplier());
                } else if (this.getGrowth() >= this.getMaxGrowth()) {
                    this.growUp((class_1297)this);
                }
                if (!this.method_5782()) {
                    this.setCarryDamage(0.0f);
                }
                if (this.method_6032() != this.method_6063() && this.method_5968() == null && this.field_6012 % 20 == 0) {
                    ++this.healCounter;
                    if (CommonMod.config.enableLogging) {
                        CommonMod.LOGGER.warn("Current Health: {} and Max Health: {} of {}", (Object)Float.valueOf(this.method_6032()), (Object)Float.valueOf(this.method_6063()), (Object)this.method_5476().getString());
                    }
                    if (this.healCounter >= 20 && (float)this.healCounter > this.field_6253) {
                        float healAmount = 3.5833f;
                        if (this.method_37908().method_29556(this.method_5829().method_1014(5.0)).anyMatch(state -> state.method_26164(GigTags.NEST_BLOCKS))) {
                            healAmount *= 1.5f;
                        }
                        if (CommonMod.config.enableLogging) {
                            CommonMod.LOGGER.warn("Now healing for {}", (Object)Float.valueOf(healAmount));
                        }
                        this.method_6025(healAmount);
                        this.healCounter = 0;
                        this.field_6253 = 0.0f;
                    }
                }
                if (this.isExecuting()) {
                    this.field_6189.method_6340();
                }
                AzureTicker.tick((class_1937)serverLevel, this.vibrationData, this.vibrationUser);
            }
        }
        if (this.field_6012 % 10 == 0) {
            this.method_18382();
        }
    }

    protected void method_6010(@NotNull class_6862<class_3611> fluid) {
    }

    public boolean method_17326() {
        return true;
    }

    public void method_5982() {
    }

    public void method_6078(@NotNull class_1282 source) {
        boolean damageCheck;
        if (DamageSourceUtils.isDamageSourceNotPuncturing(source, this.method_48923()) || source == this.method_48923().method_51847()) {
            super.method_6078(source);
            return;
        }
        boolean bl = damageCheck = !this.method_37908().field_9236 && source != this.method_48923().method_51847() || source != this.method_48923().method_48830();
        if (damageCheck && !this.method_5864().method_20210(GigTags.NO_ACID_BLOOD)) {
            if (this.getAcidDiameter() == 1) {
                GigCommonMethods.generateAcidPool((class_1309)this, this.method_24515(), 0, 0);
            } else {
                int radius = (this.getAcidDiameter() - 1) / 2;
                for (int i = 0; i < this.getAcidDiameter(); ++i) {
                    int x = this.method_37908().method_8409().method_43048(this.getAcidDiameter()) - radius;
                    int z = this.method_37908().method_8409().method_43048(this.getAcidDiameter()) - radius;
                    if (source == this.method_48923().method_51847() && source == this.method_48923().method_48830()) continue;
                    GigCommonMethods.generateAcidPool((class_1309)this, this.method_24515(), x, z);
                }
            }
        }
        super.method_6078(source);
    }

    public void method_42147(@NotNull BiConsumer<class_5715<?>, class_3218> biConsumer) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            biConsumer.accept(this.dynamicGameEventListener, serverLevel);
        }
    }

    public void method_6091(@NotNull class_243 travelVector) {
        if (this.method_6034() && this.method_5869()) {
            this.method_5724(0.1f, travelVector);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(travelVector);
        }
    }

    @NotNull
    public class_3414 method_6011(@NotNull class_1282 source) {
        return GigSounds.ALIEN_HURT.get();
    }

    @NotNull
    public class_3414 method_6002() {
        return GigSounds.ALIEN_DEATH.get();
    }

    @NotNull
    protected class_3414 method_5625() {
        return class_3417.field_14887;
    }

    @NotNull
    protected class_3414 method_5737() {
        return class_3417.field_15172;
    }

    public boolean method_5810() {
        return false;
    }

    public void grabTarget(class_1297 entity) {
        if (entity == this.method_5968() && !entity.method_5626((class_1297)this) && entity.method_55667().method_26204() != GigBlocks.NEST_RESIN_WEB_CROSS) {
            entity.method_5873((class_1297)this, true);
            this.method_19540(false);
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                player.field_13987.method_14364((class_2596)new class_2752(entity));
            }
        }
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        class_1297 class_12972;
        float multiplier = 1.0f;
        if (source == this.method_48923().method_48813()) {
            multiplier = 2.0f;
        }
        if (source == this.method_48923().method_48822()) {
            return false;
        }
        if (this.method_5782() && !this.method_37908().field_9236) {
            this.setCarryDamage(this.getCarryDamage() + amount);
            if (this.getCarryDamage() > 15.0f) {
                this.method_5772();
                this.method_6092(new class_1293(class_1294.field_5916, 60, 10, false, false));
                this.method_6092(new class_1293(class_1294.field_5909, 60, 10, false, false));
                GigCommonMethods.setAnimation(this.animationDispatcher::sendUnkidnap);
            }
        }
        if (!this.method_37908().field_9236 && source.method_5529() != null && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            this.field_18321.method_18878(class_4140.field_22355, (Object)attacker);
        }
        if (DamageSourceUtils.isDamageSourceNotPuncturing(source, this.method_48923())) {
            return super.method_5643(source, amount);
        }
        if (!this.method_37908().field_9236 && source != this.method_48923().method_51847() && !this.method_5864().method_20210(GigTags.NO_ACID_BLOOD) && this.method_5805() && amount > 8.0f) {
            if (this.getAcidDiameter() == 1) {
                GigCommonMethods.generateAcidPool((class_1309)this, this.method_24515(), 0, 0);
            } else {
                int radius = (this.getAcidDiameter() - 1) / 2;
                for (int i = 0; i < this.getAcidDiameter(); ++i) {
                    int x = this.method_37908().method_8409().method_43048(this.getAcidDiameter()) - radius;
                    int z = this.method_37908().method_8409().method_43048(this.getAcidDiameter()) - radius;
                    if (source == this.method_48923().method_51847() && source == this.method_48923().method_48830()) continue;
                    GigCommonMethods.generateAcidPool((class_1309)this, this.method_24515(), x, z);
                }
            }
        }
        if (source != this.method_48923().method_51847()) {
            float safeAmount = Math.max(amount, 1.0f);
            float adjustedAmount = safeAmount > 50.0f ? safeAmount / (float)Math.log10(safeAmount) : safeAmount;
            return super.method_5643(source, adjustedAmount);
        }
        return super.method_5643(source, amount * multiplier);
    }

    @Override
    public float getMaxGrowth() {
        return 300.0f;
    }

    @Override
    public class_1309 growInto() {
        return null;
    }

    @NotNull
    public class_8514.class_8515 method_51298() {
        return this.vibrationData;
    }

    @NotNull
    public class_8514.class_5719 method_51299() {
        return this.vibrationUser;
    }

    public void drop(class_1309 target, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        double d = target.method_23320() - (double)0.3f;
        class_1542 itemEntity = new class_1542(target.method_37908(), target.method_23317(), d, target.method_23321(), itemStack);
        itemEntity.method_6982(40);
        float g = class_3532.method_15374((float)(this.method_36455() * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180)));
        float i = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
        float j = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
        float k = this.field_5974.method_43057() * ((float)Math.PI * 2);
        float l = 0.02f * this.field_5974.method_43057();
        itemEntity.method_18800((double)(-i * h * 0.3f) + Math.cos(k) * (double)l, (double)(-g * 0.3f + 0.010000001f), (double)(j * h * 0.3f) + Math.sin(k) * (double)l);
        target.method_37908().method_8649((class_1297)itemEntity);
    }

    public void shootAcid(class_1309 target, class_1309 attacker) {
        AcidSpitProjectile acidProjectile;
        if (attacker.method_6057((class_1297)target) && (acidProjectile = (AcidSpitProjectile)GigEntities.ACID_PROJECTILE.get().method_5883(this.method_37908())) != null) {
            class_243 attackDirection = attacker.method_5828(1.0f);
            acidProjectile.method_5814(attacker.method_23317() + attackDirection.field_1352 * 2.0, attacker.method_23323(0.5), attacker.method_23321() + attackDirection.field_1350 * 2.0);
            double dx = target.method_23317() - acidProjectile.method_23317();
            double dy = target.method_23323(0.5) - acidProjectile.method_23318();
            double dz = target.method_23321() - acidProjectile.method_23321();
            float velocity = 1.0f;
            float inaccuracy = 0.1f;
            acidProjectile.method_7485(dx, dy, dz, velocity, inaccuracy);
            attacker.method_37908().method_8649((class_1297)acidProjectile);
        }
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (player.method_5998(hand).method_31574(class_1802.field_8550) && !player.method_37908().method_8608()) {
            player.method_5998(hand).method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
            player.method_37222(new class_1293(GigStatusEffects.ACID, 100, 0), (class_1297)this);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_8779 advancement = serverPlayer.field_13995.method_3851().method_12896(Constants.modResource("dontdothat"));
                if (advancement != null && !serverPlayer.method_14236().method_12882(advancement).method_740()) {
                    for (String s : serverPlayer.method_14236().method_12882(advancement).method_731()) {
                        serverPlayer.method_14236().method_12878(advancement, s);
                    }
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (player.method_5998(hand).method_31574(class_1802.field_8469) && !player.method_37908().method_8608()) {
            player.method_5998(hand).method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
            player.method_5643(GigDamageSources.of(player.method_37908(), GigDamageSources.ACID), CommonMod.config.acidDamage);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_8779 advancement = serverPlayer.field_13995.method_3851().method_12896(Constants.modResource("dontacidbottle"));
                if (advancement != null && !serverPlayer.method_14236().method_12882(advancement).method_740()) {
                    for (String s : serverPlayer.method_14236().method_12882(advancement).method_731()) {
                        serverPlayer.method_14236().method_12878(advancement, s);
                    }
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public boolean method_42150(@NotNull class_1309 entity) {
        if (this.method_5829().method_1014(1.25).method_994(entity.method_5829())) {
            return true;
        }
        return super.method_42150(entity);
    }

    public boolean method_33189() {
        return true;
    }

    public boolean method_6101() {
        class_2338.class_2339 blockPos = new class_2338.class_2339(this.method_19538().field_1352, this.method_19538().field_1351 + 2.0, this.method_19538().field_1350);
        if (this.method_37908().method_8320((class_2338)blockPos).method_51366()) {
            this.inTwoBlockSpace = true;
        }
        if (!this.method_37908().method_8320((class_2338)blockPos).method_51366()) {
            this.inTwoBlockSpace = false;
        }
        return this.inTwoBlockSpace;
    }

    public void setMoveControl(class_1335 moveControl) {
        this.field_6207 = moveControl;
    }

    public void setNavigation(class_1408 navigation) {
        this.field_6189 = navigation;
    }

    public void method_5790() {
        if (!this.method_37908().field_9236) {
            if (this.method_6034() && this.method_5869() && !this.method_37908().method_8320(this.method_24515().method_10084()).method_26215()) {
                this.navigationManager.switchToWater(this);
                this.method_5796(true);
            } else {
                this.navigationManager.switchToGround(this);
                this.method_5796(false);
            }
        }
    }

    protected void runLungeAnimation() {
        this.animationDispatcher.sendLunge();
    }

    protected void checkAndPerformEating(class_1542 target) {
        if (target == null) {
            return;
        }
        if (this.isBirthed()) {
            return;
        }
        if (this.getGrowth() < 10.0f) {
            return;
        }
        if (this.isWithinEatingRange(target)) {
            this.method_5951((class_1297)target, 10.0f, 10.0f);
            if (this.delayBeforeEating > 0) {
                --this.delayBeforeEating;
                if (this.delayBeforeEating == 5 && !this.triggeredAttackAnimation) {
                    this.animationDispatcher.sendChomp();
                    this.triggeredAttackAnimation = true;
                }
            } else {
                float growthValue;
                if (target.method_6983().method_31573(GigTags.POTIONS)) {
                    this.method_5783(class_3417.field_15081, 1.0f, 1.0f);
                } else {
                    this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
                }
                this.method_6104(class_1268.field_5808);
                if (target.method_6983().method_57826(class_9334.field_50075)) {
                    class_4174 foodComponent = (class_4174)target.method_6983().method_57824(class_9334.field_50075);
                    growthValue = (float)foodComponent.comp_2491() * 20.0f;
                    target.method_6983().method_7910(this.method_37908(), (class_1309)this);
                } else {
                    growthValue = 20.0f;
                    if (target.method_6983().method_31573(GigTags.POTIONS)) {
                        target.method_6983().method_7910(this.method_37908(), (class_1309)this);
                        target.method_6983().method_57008(1, (class_1309)this);
                    } else {
                        target.method_6983().method_57008(1, (class_1309)this);
                    }
                }
                this.setGrowth(this.getGrowth() + growthValue);
                this.triggeredAttackAnimation = false;
                this.delayBeforeEating = 20;
            }
        } else {
            --this.delayBeforeEating;
            this.triggeredAttackAnimation = false;
        }
    }

    public boolean isWithinEatingRange(@NotNull class_1542 entity) {
        for (class_2338 testPos : class_2338.method_10097((class_2338)this.method_24515().method_10079(this.method_5735(), 1).method_10086(-1).method_10079(this.method_5735().method_10170(), -1), (class_2338)this.method_24515().method_10079(this.method_5735(), 3).method_10086(1).method_10079(this.method_5735().method_10170(), 1))) {
            if (!entity.method_24515().equals((Object)testPos)) continue;
            return true;
        }
        return this.method_5829().method_994(entity.method_5829().method_1014(1.5));
    }
}

