/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.EnumSet;
import java.util.Optional;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public class LungeAtFoodTargetGoal
extends class_1352 {
    private static final int DEFAULT_WIND_UP_TIME_IN_TICKS = 10;
    private static final float DEFAULT_DISTANCE_TARGET = -1.0f;
    private final class_1308 mob;
    private final int maxCooldown;
    private final float normalizedChance;
    private final double minLungeRange = 1.0;
    private final double maxLungeRange;
    private float distanceToTarget;
    private int windUpTimeInTicks;
    private int cooldown;
    @Nullable
    Runnable onLungeCallback;

    public LungeAtFoodTargetGoal(class_1308 mob, float normalizedChance, int cooldown, double maxLungeRange) {
        this.mob = mob;
        this.maxCooldown = cooldown;
        this.normalizedChance = normalizedChance;
        this.maxLungeRange = maxLungeRange;
        this.cooldown = 0;
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        AlienEntity alienEntity;
        class_1308 class_13082 = this.mob;
        if (class_13082 instanceof AlienEntity && ((alienEntity = (AlienEntity)class_13082).isBirthed() || alienEntity.getGrowth() > 10.0f)) {
            return false;
        }
        this.cooldown = Math.max(this.cooldown - 1, 0);
        boolean canUse = !this.isOnCooldown() && this.mob.method_59922().method_43057() < this.normalizedChance;
        Optional target = this.mob.method_37908().method_18467(class_1542.class, this.mob.method_5829().method_1014(5.0)).stream().findFirst();
        return target.isPresent() && this.mob.method_24828() && this.isInRange() && !this.canPathfind() && canUse && this.mob.method_5985().method_6369((class_1297)target.get());
    }

    public boolean method_6266() {
        AlienEntity alienEntity;
        class_1308 class_13082 = this.mob;
        if (class_13082 instanceof AlienEntity && ((alienEntity = (AlienEntity)class_13082).isBirthed() || alienEntity.getGrowth() > 10.0f)) {
            return false;
        }
        Optional target = this.mob.method_37908().method_18467(class_1542.class, this.mob.method_5829().method_1014(5.0)).stream().findFirst();
        return !this.canPathfind() && target.isPresent() && this.mob.method_24828() && this.mob.method_5985().method_6369((class_1297)target.get());
    }

    public void method_6269() {
        super.method_6269();
        Optional target = this.mob.method_37908().method_18467(class_1542.class, this.mob.method_5829().method_1014(5.0)).stream().findFirst();
        if (target != null) {
            this.mob.method_5988().method_6226((class_1297)target.get(), 180.0f, 180.0f);
        }
    }

    public void method_6268() {
        Optional target = this.mob.method_37908().method_18467(class_1542.class, this.mob.method_5829().method_1014(5.0)).stream().findFirst();
        if (target.isEmpty()) {
            return;
        }
        this.mob.method_5988().method_6226((class_1297)target.get(), 180.0f, 180.0f);
        float currentDistanceToTarget = this.mob.method_5739((class_1297)target.get());
        if (this.distanceToTarget == -1.0f) {
            this.distanceToTarget = currentDistanceToTarget;
        }
        if (this.mob.method_6117() > 0 && this.mob.field_6012 - this.mob.method_6117() < 20 || currentDistanceToTarget > this.distanceToTarget) {
            this.windUpTimeInTicks = 0;
        }
        if (this.windUpTimeInTicks > 0) {
            --this.windUpTimeInTicks;
            this.mob.method_5942().method_6340();
            return;
        }
        this.distanceToTarget = currentDistanceToTarget;
        class_243 deltaMovement = this.mob.method_18798().method_1021(0.2);
        class_243 vectorDifference = ((class_1542)target.get()).method_33571().method_1020(this.mob.method_33571());
        vectorDifference = vectorDifference.method_1029().method_1021(0.2 * (double)this.distanceToTarget).method_1031(deltaMovement.field_1352, 0.0, deltaMovement.field_1350);
        this.mob.method_18800(vectorDifference.field_1352, Math.max(0.6, vectorDifference.field_1351), vectorDifference.field_1350);
        if (this.onLungeCallback != null) {
            this.onLungeCallback.run();
        }
        this.resetWindUpTimeInTicks();
        this.resetCooldown();
    }

    public void method_6270() {
        super.method_6270();
        this.resetCooldown();
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
    }

    public boolean method_38846() {
        return true;
    }

    public LungeAtFoodTargetGoal setOnLungeCallback(@Nullable Runnable onLungeCallback) {
        this.onLungeCallback = onLungeCallback;
        return this;
    }

    private boolean isOnCooldown() {
        return this.cooldown > 0;
    }

    private void resetCooldown() {
        this.cooldown = this.maxCooldown;
    }

    private void resetWindUpTimeInTicks() {
        this.windUpTimeInTicks = 10;
    }

    private boolean isInRange() {
        Optional target = this.mob.method_37908().method_18467(class_1542.class, this.mob.method_5829().method_1014(5.0)).stream().findFirst();
        if (target.isEmpty()) {
            return false;
        }
        double distanceToHost = this.mob.method_5858((class_1297)target.get());
        double minimumRangeSquared = 1.0;
        double maximumRangeSquared = this.maxLungeRange * this.maxLungeRange;
        return distanceToHost <= maximumRangeSquared && distanceToHost >= minimumRangeSquared;
    }

    private boolean canPathfind() {
        Optional target = this.mob.method_37908().method_18467(class_1542.class, this.mob.method_5829().method_1014(5.0)).stream().findFirst();
        if (target.isEmpty()) {
            return false;
        }
        return !this.mob.method_5942().method_6335((class_1297)target.get(), 1.0);
    }
}

