/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.mixins.common.entity;

import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.helper.GigCommonMethods;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.fluid.GigFluids;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.status.effect.impl.DNAStatusEffect;
import mods.cybercat.gigeresque.common.status.effect.impl.EggMorphingStatusEffect;
import mods.cybercat.gigeresque.common.status.effect.impl.ImpregnationStatusEffect;
import mods.cybercat.gigeresque.common.status.effect.impl.SporeStatusEffect;
import mods.cybercat.gigeresque.common.status.effect.impl.TraumaStatusEffect;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import net.minecraft.class_8779;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    abstract boolean method_6092(class_1293 var1);

    @Shadow
    public abstract boolean method_5643(@NotNull class_1282 var1, float var2);

    @Shadow
    public abstract boolean method_29504();

    @Shadow
    public abstract float method_6063();

    @Shadow
    public abstract boolean method_5805();

    @Shadow
    public abstract float method_6032();

    @Shadow
    public abstract boolean method_6016(class_6880<class_1291> var1);

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void gigeresque$hurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.method_5854() != null && this.method_5854().method_5864().method_20210(GigTags.GIG_ALIENS) && (source == this.method_48923().method_48824() || source == this.method_48923().method_48822())) {
            callbackInfo.setReturnValue((Object)false);
        }
        if (amount >= 2.0f && this.method_31483() != null) {
            if (this.method_5685().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
                FacehuggerEntity facehugger = (FacehuggerEntity)this.method_31483();
                facehugger.method_5643(source, amount / 2.0f);
                facehugger.method_6092(new class_1293(class_1294.field_5916, CommonMod.config.facehuggerConfigs.facehuggerStunTickTimer, 60, false, false));
                facehugger.method_6092(new class_1293(class_1294.field_5909, 60, 10, false, false));
                facehugger.animationDispatcher.sendStunned();
                facehugger.detachFromHost();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void gigeresque$tick(CallbackInfo callbackInfo) {
        if (!this.method_37908().field_9236) {
            class_3611 getType;
            if (this.method_5685().stream().anyMatch(AlienEntity.class::isInstance)) {
                this.method_5855(this.method_5748());
            }
            if (Constants.hasCureEffects.test(this)) {
                this.method_6016(GigStatusEffects.DNA);
                Object t = Constants.self((Object)this);
                if (t instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)t;
                    class_8779 advancement = serverPlayer.field_13995.method_3851().method_12896(Constants.modResource("dna_cure"));
                    if (advancement != null) {
                        serverPlayer.method_14236().method_12878(advancement, "criteria_key");
                    }
                }
            }
            if (Constants.hasEggEffect.test(this) && !GigEntityUtils.inResinEnoughToBeEggmorphed(this)) {
                this.method_6016(GigStatusEffects.EGGMORPHING);
            }
            if (Constants.isCreativeSpecPlayer.test(this)) {
                if (Constants.hasEggEffect.test(this)) {
                    this.method_6016(GigStatusEffects.EGGMORPHING);
                }
                if (Constants.hasImpEffect.test(this)) {
                    this.method_6016(GigStatusEffects.IMPREGNATION);
                }
                if (Constants.hasDNAEffect.test(this)) {
                    this.method_6016(GigStatusEffects.DNA);
                }
                if (Constants.hasSporeEffect.test(this)) {
                    this.method_6016(GigStatusEffects.SPORE);
                }
            }
            if (Constants.shouldApplyImpEffects.test(this)) {
                GigCommonMethods.generateBloodPool((class_1309)Constants.self((Object)this), this.method_24515().method_10084(), 0, 0);
                this.method_5643(GigDamageSources.of(this.method_37908(), GigDamageSources.CHESTBURSTING), 0.2f);
            }
            if ((getType = this.method_37908().method_8316(this.method_24515()).method_15772()) == GigFluids.BLACK_FLUID_STILL.get() || getType == GigFluids.BLACK_FLUID_FLOWING.get()) {
                this.gigeresque$handleBlackGooLogic(this);
            }
        }
    }

    @Unique
    private void gigeresque$handleBlackGooLogic(class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        if (this.method_6059(GigStatusEffects.DNA) || GigEntityUtils.isTargetDNAImmune((class_1297)livingEntity)) {
            return;
        }
        if (Constants.notPlayer.test((class_1297)livingEntity) && !Constants.isCreeper.test(this)) {
            this.method_6092(new class_1293(GigStatusEffects.DNA, CommonMod.config.getgooEffectTickTimer(), 0));
        }
        if (Constants.isCreeper.test(this) && Constants.notPlayer.test((class_1297)livingEntity)) {
            this.method_6092(new class_1293(GigStatusEffects.DNA, 60000, 0));
        }
        if (Constants.isNotCreativeSpecPlayer.test((class_1297)livingEntity)) {
            this.method_6092(new class_1293(GigStatusEffects.DNA, CommonMod.config.getgooEffectTickTimer(), 0));
        }
    }

    @Inject(method={"isImmobile"}, at={@At(value="RETURN")}, cancellable=true)
    protected void gigeresque$isImmobile(CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.method_5685().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
            callbackInfo.setReturnValue((Object)true);
        }
    }

    @Inject(method={"removeAllEffects"}, at={@At(value="HEAD")}, cancellable=true)
    public void noMilkRemoval(CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.method_6059(GigStatusEffects.EGGMORPHING) || this.method_6059(GigStatusEffects.ACID) || this.method_6059(GigStatusEffects.DNA) || this.method_6059(GigStatusEffects.SPORE) || this.method_6059(GigStatusEffects.IMPREGNATION)) {
            callbackInfo.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V"}, at={@At(value="TAIL")})
    private void runAtEffectRemoval(class_1293 mobEffectInstance, CallbackInfo ci) {
        if (!this.method_37908().field_9236) {
            DNAStatusEffect.effectRemoval((class_1309)Constants.self((Object)this), mobEffectInstance);
            SporeStatusEffect.effectRemoval((class_1309)Constants.self((Object)this), mobEffectInstance);
            ImpregnationStatusEffect.effectRemoval((class_1309)Constants.self((Object)this), mobEffectInstance);
            EggMorphingStatusEffect.effectRemoval((class_1309)Constants.self((Object)this), mobEffectInstance);
            TraumaStatusEffect.effectRemoval((class_1309)Constants.self((Object)this), mobEffectInstance);
        }
    }
}

