package org.teamvoided.taglighting.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_7260;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import static org.teamvoided.taglighting.data.tags.TaglightingEntitiesTags.WARDEN_UNTARGETABLE;

@Mixin(class_7260.class)
public class WardenEntityMixin {

    @ModifyReturnValue(method = "canTargetEntity", at = @At("RETURN"))
    boolean makeUntargetable(boolean original, class_1297 entity) {
        if (entity instanceof class_1309 living && living.method_5864().method_20210(WARDEN_UNTARGETABLE)) {
            return false;
        }
        return original;
    }

    @ModifyExpressionValue(method = "canTargetEntity", at= @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;getType()Lnet/minecraft/world/entity/EntityType;"))
    class_1299<?> preventVanilla(class_1299<?> original){
        return null;
    }
}
