package org.teamvoided.taglighting.mixin.piston;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_2674;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.teamvoided.taglighting.data.tags.TaglightingBlockTags;

@Mixin(class_2674.class)
public abstract class PistonHandlerMixin {
    @Shadow
    private static boolean isSticky(class_2680 blockState) {
        throw new UnsupportedOperationException("Mixin did not apply!");
    }

    @ModifyReturnValue(method = "isSticky", at = @At("RETURN"))
    private static boolean isUniqueStickBlock(boolean original, class_2680 state) {
        return state.method_26164(TaglightingBlockTags.UNIQUE_STICKY_BLOCK);
    }

    @ModifyReturnValue(method = "canStickToEachOther", at = @At("RETURN"))
    private static boolean isAdjacentBlockStuck(boolean original, class_2680 state, class_2680 adjacentState) {
        return !(isSticky(state) && (state != adjacentState && isSticky(adjacentState)));
    }
}
