package net.gnomecraft.cooldowncoordinator.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import net.gnomecraft.cooldowncoordinator.*;
import net.minecraft.block.entity.*;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2614.class)
public abstract class MixinHopperBlockEntity extends class_2621 implements CoordinatedCooldown {
    @Shadow
    private long lastTickTime;
    @Shadow
    protected abstract boolean isDisabled();
    @Shadow
    protected abstract void setTransferCooldown(int transferCooldown);

    protected MixinHopperBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    /**
     * The notifyCooldown() method of the CoordinatedCooldown interface does not have a default implementation.
     * Because of this, despite our use of interface injection, {@code ((HopperBlockEntity) entity).notifyCooldown() }
     * will not compile.  If you need to call this method directly it is recommended to cast the HopperBlockEntity
     * to CoordinatedCooldown:
     *
     * <pre>{@code
     *     if (entity instanceof CoordinatedCooldown cooldownEntity) {
     *         cooldownEntity.notifyCooldown();
     *     }
     * }</pre>
     *
     * However, don't do that.  Just call {@code CooldownCoordinator.notify(targetEntity); } and let it notify.
     */
    @SuppressWarnings("AddedMixinMembersNamePattern")
    @Override
    public void notifyCooldown() {
        // Insert implementation of the CoordinatedCooldown interface into HBE.
        // This mirrors what happens just after one hopper transfers to another.
        // See the example in the javadocs for CoordinatedCooldown.notifyCooldown()
        if (!this.isDisabled()) {
            if (this.field_11863 != null && this.lastTickTime >= this.field_11863.method_75260()) {
                this.setTransferCooldown(7);
            } else {
                this.setTransferCooldown(8);
            }
            this.method_5431();
        }

    }

    // This injection patches the traditional Inventory-based HopperBlockEntity code to call notify().
    @SuppressWarnings({"DiscouragedShift", "LocalMayBeArgsOnly"})
    @Inject(
			at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/inventory/Inventory;markDirty()V",
                    shift = At.Shift.BEFORE
            ),
            method = "transfer(Lnet/minecraft/inventory/Inventory;Lnet/minecraft/inventory/Inventory;Lnet/minecraft/item/ItemStack;ILnet/minecraft/util/math/Direction;)Lnet/minecraft/item/ItemStack;"
    )
    private static void CooldownCoordinator$injectCoordinator(class_1263 from, class_1263 to, class_1799 stack, int slot, class_2350 side, CallbackInfoReturnable<class_1799> cir, @Local(ordinal = 1) boolean bl2) {
        // bl2 indicates whether the destination inventory was empty before the hopper moved an item into it
        if (bl2 && to instanceof class_2586 toEntity) {
            CooldownCoordinator.notify(toEntity);
        }
    }
}