/*
 * Decompiled with CFR 0.152.
 */
package net.gnomecraft.cooldowncoordinator;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.gnomecraft.cooldowncoordinator.CoordinatedCooldown;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CooldownCoordinator
implements ModInitializer {
    public static final String modId = "cooldown-coordinator";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cooldown-coordinator");

    public void onInitialize() {
        LOGGER.info("Cooldown Coordinator library loaded.");
    }

    public static boolean notify(@Nullable class_2586 entity) {
        if (entity == null) {
            return false;
        }
        class_1937 world = entity.method_10997();
        if (world == null || world.method_8608()) {
            return false;
        }
        if (entity instanceof CoordinatedCooldown) {
            CoordinatedCooldown coordinatedEntity = (CoordinatedCooldown)entity;
            LOGGER.debug("Notifying BE: " + String.valueOf(entity));
            coordinatedEntity.notifyCooldown();
            return true;
        }
        LOGGER.debug("Cannot notify BE: " + String.valueOf(entity));
        return false;
    }

    public static boolean isStorageEmpty(@Nullable Storage<?> storage) {
        if (storage == null) {
            return true;
        }
        return StorageUtil.findStoredResource(storage) == null;
    }

    @Deprecated(forRemoval=true)
    public static boolean isItemStorageEmpty(@Nullable Storage<ItemVariant> storage) {
        return CooldownCoordinator.isStorageEmpty(storage);
    }

    public static boolean isInventoryEmpty(@Nullable class_1263 inventory) {
        if (inventory == null) {
            return true;
        }
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack == null || stack.method_7960()) continue;
            return false;
        }
        return true;
    }
}

